/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.press;

import com.simibubi.create.AllRecipes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.press.PressingRecipe;
import com.simibubi.create.modules.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.modules.contraptions.processing.BasinTileEntity;
import com.simibubi.create.modules.logistics.InWorldProcessing;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MechanicalPressTileEntity
extends BasinOperatingTileEntity {
    private static Object compressingRecipesKey = new Object();
    public List<ItemStack> pressedItems = new ArrayList<ItemStack>();
    private static PressingInv pressingInv = new PressingInv();
    public int runningTicks;
    public boolean running;
    public Mode mode = Mode.WORLD;
    public boolean finished;

    public MechanicalPressTileEntity() {
        super(AllTileEntities.MECHANICAL_PRESS.type);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.running = compound.func_74767_n("Running");
        this.mode = Mode.values()[compound.func_74762_e("Mode")];
        this.finished = compound.func_74767_n("Finished");
        this.runningTicks = compound.func_74762_e("Ticks");
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Running", this.running);
        compound.func_74768_a("Mode", this.mode.ordinal());
        compound.func_74757_a("Finished", this.finished);
        compound.func_74768_a("Ticks", this.runningTicks);
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT tag) {
        ListNBT particleItems = new ListNBT();
        this.pressedItems.forEach(stack -> particleItems.add((Object)stack.serializeNBT()));
        tag.func_218657_a("ParticleItems", (INBT)particleItems);
        return super.writeToClient(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        super.readClientUpdate(tag);
        ListNBT particleItems = tag.func_150295_c("ParticleItems", 10);
        particleItems.forEach(nbt -> this.pressedItems.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt))));
        this.spawnParticles();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, -1.5, 0.0).func_72321_a(0.0, 1.0, 0.0);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (this.running) {
            if (this.runningTicks < 40) {
                float num = ((float)(this.runningTicks - 1) + partialTicks) / 30.0f;
                return MathHelper.func_76131_a((float)(num * num * num), (float)0.0f, (float)this.mode.headOffset);
            }
            if (this.runningTicks >= 40) {
                return MathHelper.func_76131_a((float)(((float)(60 - this.runningTicks + 1) - partialTicks) / 20.0f * this.mode.headOffset), (float)0.0f, (float)this.mode.headOffset);
            }
        }
        return 0.0f;
    }

    public void start(Mode mode) {
        this.mode = mode;
        this.running = true;
        this.runningTicks = 0;
        this.pressedItems.clear();
        this.sendData();
    }

    public boolean inWorld() {
        return this.mode == Mode.WORLD;
    }

    public boolean onBelt() {
        return this.mode == Mode.BELT;
    }

    public boolean onBasin() {
        return this.mode == Mode.BASIN;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.running) {
            return;
        }
        if (this.runningTicks == 30) {
            if (this.inWorld()) {
                AxisAlignedBB bb = new AxisAlignedBB(this.field_174879_c.func_177979_c(1));
                this.pressedItems.clear();
                for (Entity entity : this.field_145850_b.func_72839_b(null, bb)) {
                    if (!(entity instanceof ItemEntity)) continue;
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (this.field_145850_b.field_72995_K) continue;
                    this.pressedItems.add(itemEntity.func_92059_d());
                    this.sendData();
                    Optional<PressingRecipe> recipe = this.getRecipe(itemEntity.func_92059_d());
                    if (!recipe.isPresent()) continue;
                    InWorldProcessing.applyRecipeOn(itemEntity, (IRecipe)recipe.get());
                    AllTriggers.triggerForNearbyPlayers(AllTriggers.BONK, this.field_145850_b, this.field_174879_c, 4);
                }
            }
            if (this.onBasin() && !this.field_145850_b.field_72995_K) {
                this.pressedItems.clear();
                this.applyBasinRecipe();
                IItemHandler orElse = (IItemHandler)this.basinInv.orElse(null);
                if (this.basinInv.isPresent() && orElse instanceof BasinTileEntity.BasinInventory) {
                    BasinTileEntity.BasinInventory inv = (BasinTileEntity.BasinInventory)orElse;
                    for (int slot = 0; slot < inv.getInputHandler().getSlots(); ++slot) {
                        ItemStack stackInSlot = inv.getStackInSlot(slot);
                        if (stackInSlot.func_190926_b()) continue;
                        this.pressedItems.add(stackInSlot);
                    }
                }
                this.sendData();
            }
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), AllSoundEvents.MECHANICAL_PRESS_ITEM_BREAK.get(), SoundCategory.BLOCKS, 0.5f, 1.0f);
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.get(), SoundCategory.BLOCKS, 0.125f, 1.0f);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.runningTicks > 60) {
            this.finished = true;
            if (this.inWorld()) {
                this.finished = this.field_145850_b.func_175640_z(this.field_174879_c);
            }
            this.running = false;
            if (this.onBasin()) {
                this.gatherInputs();
                if (this.matchBasinRecipe(this.lastRecipe)) {
                    this.startProcessingBasin();
                }
            }
            this.pressedItems.clear();
            this.sendData();
            return;
        }
        ++this.runningTicks;
    }

    protected void spawnParticles() {
        if (this.pressedItems.isEmpty()) {
            return;
        }
        if (this.mode == Mode.BASIN) {
            this.pressedItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((Vec3i)this.field_174879_c.func_177979_c(2)), (ItemStack)stack));
        }
        if (this.mode == Mode.BELT) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)this.field_174879_c.func_177979_c(2)).func_72441_c(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.pressedItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)this.field_174879_c.func_177979_c(1)).func_72441_c(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.pressedItems.clear();
    }

    public void makePressingParticleEffect(Vec3d pos, ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                Vec3d motion = VecHelper.offsetRandomly(Vec3d.field_186680_a, this.field_145850_b.field_73012_v, 0.125f).func_216372_d(1.0, 0.0, 1.0);
                this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), pos.field_72450_a, pos.field_72448_b - 0.25, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.125, motion.field_72449_c);
            }
        }
    }

    public void makeCompactingParticleEffect(Vec3d pos, ItemStack stack) {
        if (this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                Vec3d motion = VecHelper.offsetRandomly(Vec3d.field_186680_a, this.field_145850_b.field_73012_v, 0.175f).func_216372_d(1.0, 0.0, 1.0);
                this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.25, motion.field_72449_c);
            }
        }
    }

    public Optional<PressingRecipe> getRecipe(ItemStack item) {
        pressingInv.func_70299_a(0, item);
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(AllRecipes.PRESSING.getType(), (IInventory)pressingInv, this.field_145850_b);
        return recipe;
    }

    public static boolean canCompress(NonNullList<Ingredient> ingredients) {
        return (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.condenseIngredients(ingredients).size() == 1;
    }

    @Override
    protected <C extends IInventory> boolean matchStaticFilters(IRecipe<C> recipe) {
        return recipe instanceof ICraftingRecipe && MechanicalPressTileEntity.canCompress((NonNullList<Ingredient>)recipe.func_192400_c());
    }

    @Override
    protected <C extends IInventory> boolean matchBasinRecipe(IRecipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        NonNullList ingredients = recipe.func_192400_c();
        if (!ingredients.stream().allMatch(Ingredient::isSimple)) {
            return false;
        }
        ArrayList remaining = new ArrayList();
        this.inputs.forEach(stack -> remaining.add(stack.func_77946_l()));
        block0: for (Ingredient ingredient : ingredients) {
            for (ItemStack stack2 : remaining) {
                if (stack2.func_190926_b() || !ingredient.test(stack2)) continue;
                stack2.func_190918_g(1);
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 30) {
            return;
        }
        super.startProcessingBasin();
        this.start(Mode.BASIN);
    }

    @Override
    protected void basinRemoved() {
        this.pressedItems.clear();
        super.basinRemoved();
        this.running = false;
        this.runningTicks = 0;
        this.sendData();
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }

    public static class PressingInv
    extends RecipeWrapper {
        public PressingInv() {
            super((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }
}

