/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.components.saw;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.block.SafeTileEntityRenderer;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.contraptions.base.IRotate;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.components.saw.SawBlock;
import com.simibubi.create.modules.contraptions.components.saw.SawTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.MathHelper;

public class SawTileEntityRenderer
extends SafeTileEntityRenderer<SawTileEntity> {
    @Override
    public void renderWithGL(SawTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        this.renderItems(te, x, y, z, partialTicks);
        FilteringRenderer.renderOnTileEntity(te, x, y, z, partialTicks, destroyStage);
        this.renderShaft(te, x, y, z);
    }

    protected void renderShaft(SawTileEntity te, double x, double y, double z) {
        TessellatorHelper.prepareFastRender();
        TessellatorHelper.begin(DefaultVertexFormats.field_176600_a);
        KineticTileEntityRenderer.renderRotatingBuffer(te, this.func_178459_a(), this.getRotatedModel(te), x, y, z, Tessellator.func_178181_a().func_178180_c());
        TessellatorHelper.draw();
    }

    protected void renderItems(SawTileEntity te, double x, double y, double z, float partialTicks) {
        boolean processingMode;
        boolean bl = processingMode = te.func_195044_w().func_177229_b((IProperty)SawBlock.FACING) == Direction.UP;
        if (processingMode && !te.inventory.isEmpty()) {
            float offset;
            boolean alongZ = (Boolean)te.func_195044_w().func_177229_b((IProperty)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            GlStateManager.pushMatrix();
            boolean moving = te.inventory.recipeDuration != 0.0f;
            float f = offset = moving ? te.inventory.remainingTime / te.inventory.recipeDuration : 0.0f;
            if (moving) {
                offset = MathHelper.func_76131_a((float)(offset + (-partialTicks + 0.5f) / te.inventory.recipeDuration), (float)0.0f, (float)1.0f);
            }
            if (te.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (te.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            ItemStack stack = te.inventory.getStackInSlot(0);
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            IBakedModel modelWithOverrides = itemRenderer.func_204206_b(stack);
            boolean blockItem = modelWithOverrides.func_177556_c();
            GlStateManager.translated((double)(x + (alongZ ? (double)offset : 0.5)), (double)(y + (double)(blockItem ? 0.925f : 0.8125f)), (double)(z + (alongZ ? 0.5 : (double)offset)));
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            if (alongZ) {
                GlStateManager.rotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            }
            GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
            itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticTileEntity te) {
        BlockState state = te.func_195044_w();
        if (((Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H)).func_176740_k().func_176722_c()) {
            return AllBlockPartials.SHAFT_HALF.renderOnDirectional(state.func_185907_a(Rotation.CLOCKWISE_180));
        }
        return CreateClient.bufferCache.renderBlockIn(KineticTileEntityRenderer.KINETIC_TILE, this.getRenderedBlockState(te));
    }

    protected BlockState getRenderedBlockState(KineticTileEntity te) {
        BlockState state = te.func_195044_w();
        return (BlockState)AllBlocks.SHAFT.get().func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208148_A, (Comparable)((IRotate)state.func_177230_c()).getRotationAxis(state));
    }
}

