/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.particle;

import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.GogglesItem;
import com.simibubi.create.modules.contraptions.particle.RotationIndicatorParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RotationIndicatorParticle
extends SimpleAnimatedParticle {
    protected float radius;
    protected float radius1;
    protected float radius2;
    protected float speed;
    protected Direction.Axis axis;
    protected Vec3d origin;
    protected Vec3d offset;
    protected boolean isVisible;

    private RotationIndicatorParticle(World world, double x, double y, double z, int color, float radius1, float radius2, float speed, Direction.Axis axis, int lifeSpan, boolean isVisible, IAnimatedSprite sprite) {
        super(world, x, y, z, sprite, 0.0f);
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.origin = new Vec3d(x, y, z);
        this.field_70544_f *= 0.75f;
        this.field_70547_e = lifeSpan + this.field_187136_p.nextInt(32);
        this.func_187145_d(color);
        this.func_187146_c(ColorHelper.mixColors(color, 0xFFFFFF, 0.5f));
        this.func_217566_b(sprite);
        this.radius1 = radius1;
        this.radius = radius1;
        this.radius2 = radius2;
        this.speed = speed;
        this.axis = axis;
        this.isVisible = isVisible;
        this.offset = axis.func_176722_c() ? new Vec3d(0.0, 1.0, 0.0) : new Vec3d(1.0, 0.0, 0.0);
        this.func_187110_a(0.0, 0.0, 0.0);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.radius += (this.radius2 - this.radius) * 0.1f;
    }

    public void func_180434_a(BufferBuilder buffer, ActiveRenderInfo entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (!this.isVisible) {
            return;
        }
        super.func_180434_a(buffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void func_187110_a(double x, double y, double z) {
        float time = AnimationTickHolder.ticks;
        float angle = time * this.speed % 360.0f - this.speed / 2.0f * (float)this.field_70546_d * ((float)this.field_70546_d / (float)this.field_70547_e);
        Vec3d position = VecHelper.rotate(this.offset.func_186678_a((double)this.radius), angle, this.axis).func_178787_e(this.origin);
        this.field_187126_f = position.field_72450_a;
        this.field_187127_g = position.field_72448_b;
        this.field_187128_h = position.field_72449_c;
    }

    public static class Factory
    implements IParticleFactory<RotationIndicatorParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle makeParticle(RotationIndicatorParticleData data, World worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            boolean visible = player != null && GogglesItem.canSeeParticles((PlayerEntity)player);
            return new RotationIndicatorParticle(worldIn, x, y, z, data.color, data.radius1, data.radius2, data.speed, data.getAxis(), data.lifeSpan, visible, this.spriteSet);
        }
    }
}

