/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.processing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;

public class ProcessingIngredient
implements Predicate<ItemStack> {
    private float outputChance;
    private Ingredient ingredient;
    private static Random r = new Random();

    public ProcessingIngredient(Ingredient ingredient) {
        this(ingredient, 0.0f);
    }

    public ProcessingIngredient(Ingredient ingredient, float outputChance) {
        this.ingredient = ingredient;
        this.outputChance = outputChance;
    }

    public float getOutputChance() {
        return this.outputChance;
    }

    public boolean isCatalyst() {
        return this.outputChance > 0.0f;
    }

    public static ProcessingIngredient parse(PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        return new ProcessingIngredient(ingredient, buffer.readFloat());
    }

    public static ProcessingIngredient parse(JsonObject json) {
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json);
        float chance = 0.0f;
        if (json.has("return_chance")) {
            chance = json.get("return_chance").getAsFloat();
        }
        return new ProcessingIngredient(ingredient, chance);
    }

    public void write(PacketBuffer buffer) {
        this.getIngredient().func_199564_a(buffer);
        buffer.writeFloat(this.outputChance);
    }

    @Override
    public boolean test(ItemStack t) {
        return this.ingredient.test(t);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public static List<ProcessingIngredient> list(List<Ingredient> ingredients) {
        return ingredients.stream().map(ProcessingIngredient::new).collect(Collectors.toList());
    }

    public boolean remains() {
        return r.nextFloat() <= this.outputChance;
    }
}

