/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.processing;

import com.simibubi.create.AllRecipes;
import com.simibubi.create.Create;
import com.simibubi.create.modules.contraptions.processing.ProcessingIngredient;
import com.simibubi.create.modules.contraptions.processing.ProcessingOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public abstract class ProcessingRecipe<T extends IInventory>
implements IRecipe<T> {
    protected final List<ProcessingIngredient> ingredients;
    private final List<ProcessingOutput> results;
    private final IRecipeType<?> type;
    private final IRecipeSerializer<?> serializer;
    protected final ResourceLocation id;
    protected final String group;
    protected final int processingDuration;

    public ProcessingRecipe(AllRecipes recipeType, ResourceLocation id, String group, List<ProcessingIngredient> ingredients, List<ProcessingOutput> results, int processingDuration) {
        this.type = recipeType.type;
        this.serializer = recipeType.serializer;
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.results = results;
        this.processingDuration = processingDuration;
        this.validate(recipeType);
    }

    private void validate(AllRecipes recipeType) {
        if (this.ingredients.size() > this.getMaxInputCount()) {
            Create.logger.warn("Your custom " + recipeType.name() + " recipe (" + this.id.toString() + ") has more inputs (" + this.ingredients.size() + ") than supported (" + this.getMaxInputCount() + ").");
        }
        if (this.results.size() > this.getMaxOutputCount()) {
            Create.logger.warn("Your custom " + recipeType.name() + " recipe (" + this.id.toString() + ") has more outputs (" + this.results.size() + ") than supported (" + this.getMaxOutputCount() + ").");
        }
        this.ingredients.forEach(i -> {
            if (i.isCatalyst() && !this.canHaveCatalysts()) {
                Create.logger.warn("Your custom " + recipeType.name() + " recipe (" + this.id.toString() + ") has a catalyst ingredient, which act like a regular ingredient in this type.");
            }
        });
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList nonnulllist = NonNullList.func_191196_a();
        this.ingredients.forEach(e -> nonnulllist.add((Object)e.getIngredient()));
        return nonnulllist;
    }

    public int getProcessingDuration() {
        return this.processingDuration;
    }

    public List<ItemStack> rollResults() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ProcessingOutput output : this.getRollableResults()) {
            ItemStack stack = output.rollOutput();
            if (stack.func_190926_b()) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public ItemStack func_77572_b(T inv) {
        return this.func_77571_b();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return this.getRollableResults().isEmpty() ? ItemStack.field_190927_a : this.getRollableResults().get(0).getStack();
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return this.serializer;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 15;
    }

    protected boolean canHaveCatalysts() {
        return false;
    }

    public List<ProcessingOutput> getRollableResults() {
        return this.results;
    }

    public List<ProcessingIngredient> getRollableIngredients() {
        return this.ingredients;
    }

    public List<ItemStack> getPossibleOutputs() {
        return this.getRollableResults().stream().map(output -> output.getStack()).collect(Collectors.toList());
    }
}

