/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.processing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.modules.contraptions.processing.ProcessingIngredient;
import com.simibubi.create.modules.contraptions.processing.ProcessingOutput;
import com.simibubi.create.modules.contraptions.processing.ProcessingRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ProcessingRecipeSerializer<T extends ProcessingRecipe<?>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final IRecipeFactory<T> factory;

    public ProcessingRecipeSerializer(IRecipeFactory<T> factory) {
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        ArrayList<ProcessingIngredient> ingredients = new ArrayList<ProcessingIngredient>();
        for (Object e : JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            int count = 1;
            if (JSONUtils.func_151204_g((JsonObject)((JsonObject)e), (String)"count")) {
                count = JSONUtils.func_151215_f((JsonElement)e.getAsJsonObject().get("count"), (String)"count");
            }
            for (int i = 0; i < count; ++i) {
                ingredients.add(ProcessingIngredient.parse(e.getAsJsonObject()));
            }
        }
        ArrayList<ProcessingOutput> results = new ArrayList<ProcessingOutput>();
        for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"results")) {
            String s1 = JSONUtils.func_151206_a((JsonElement)e.getAsJsonObject().get("item"), (String)"item");
            int i = JSONUtils.func_151215_f((JsonElement)e.getAsJsonObject().get("count"), (String)"count");
            float chance = 1.0f;
            if (JSONUtils.func_151204_g((JsonObject)((JsonObject)e), (String)"chance")) {
                chance = JSONUtils.func_151220_d((JsonElement)e.getAsJsonObject().get("chance"), (String)"chance");
            }
            ItemStack itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_82594_a(new ResourceLocation(s1)), i);
            results.add(new ProcessingOutput(itemstack, chance));
        }
        int duration = -1;
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"processingTime")) {
            duration = JSONUtils.func_151203_m((JsonObject)json, (String)"processingTime");
        }
        return this.factory.create(recipeId, s, ingredients, results, duration);
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        ArrayList<ProcessingIngredient> ingredients = new ArrayList<ProcessingIngredient>();
        int ingredientCount = buffer.readInt();
        for (int i = 0; i < ingredientCount; ++i) {
            ingredients.add(ProcessingIngredient.parse(buffer));
        }
        ArrayList<ProcessingOutput> results = new ArrayList<ProcessingOutput>();
        int outputCount = buffer.readInt();
        for (int i = 0; i < outputCount; ++i) {
            results.add(ProcessingOutput.read(buffer));
        }
        int duration = buffer.readInt();
        return this.factory.create(recipeId, s, ingredients, results, duration);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(((ProcessingRecipe)recipe).group);
        buffer.writeInt(((ProcessingRecipe)recipe).ingredients.size());
        ((ProcessingRecipe)recipe).ingredients.forEach(i -> i.write(buffer));
        buffer.writeInt(((ProcessingRecipe)recipe).getRollableResults().size());
        ((ProcessingRecipe)recipe).getRollableResults().forEach(i -> i.write(buffer));
        buffer.writeInt(((ProcessingRecipe)recipe).processingDuration);
    }

    public static interface IRecipeFactory<T extends ProcessingRecipe<?>> {
        public T create(ResourceLocation var1, String var2, List<ProcessingIngredient> var3, List<ProcessingOutput> var4, int var5);
    }
}

