/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.redstone;

import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.modules.contraptions.redstone.AnalogLeverTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnalogLeverBlock
extends HorizontalFaceBlock
implements ITE<AnalogLeverTileEntity> {
    public AnalogLeverBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150442_at));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new AnalogLeverTileEntity();
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            AnalogLeverBlock.addParticles(state, (IWorld)worldIn, pos, 1.0f);
            return true;
        }
        try {
            boolean sneak = player.func_70093_af();
            AnalogLeverTileEntity te = (AnalogLeverTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            te.changeState(sneak);
            float f = 0.25f + (float)(te.state + 5) / 15.0f * 0.5f;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.2f, f);
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        try {
            return ((AnalogLeverTileEntity)this.getTileEntity((IBlockReader)blockAccess, (BlockPos)pos)).state;
        }
        catch (ITE.TileEntityException e) {
            return 0;
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return AnalogLeverBlock.func_196365_i((BlockState)blockState) == side ? this.func_180656_a(blockState, blockAccess, pos, side) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        try {
            AnalogLeverTileEntity tileEntity = (AnalogLeverTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            if (tileEntity.state != 0 && rand.nextFloat() < 0.25f) {
                AnalogLeverBlock.addParticles(stateIn, (IWorld)worldIn, pos, 0.5f);
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        try {
            AnalogLeverTileEntity tileEntity = (AnalogLeverTileEntity)this.getTileEntity((IBlockReader)worldIn, pos);
            if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
                if (tileEntity.state != 0) {
                    AnalogLeverBlock.updateNeighbors(state, worldIn, pos);
                }
                worldIn.func_175713_t(pos);
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
    }

    private static void addParticles(BlockState state, IWorld worldIn, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
        Direction direction1 = AnalogLeverBlock.func_196365_i((BlockState)state).func_176734_d();
        double d0 = (double)pos.func_177958_n() + 0.5 + 0.1 * (double)direction.func_82601_c() + 0.2 * (double)direction1.func_82601_c();
        double d1 = (double)pos.func_177956_o() + 0.5 + 0.1 * (double)direction.func_96559_d() + 0.2 * (double)direction1.func_96559_d();
        double d2 = (double)pos.func_177952_p() + 0.5 + 0.1 * (double)direction.func_82599_e() + 0.2 * (double)direction1.func_82599_e();
        worldIn.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 0.0f, 0.0f, alpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    static void updateNeighbors(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, state.func_177230_c());
        world.func_195593_d(pos.func_177972_a(AnalogLeverBlock.func_196365_i((BlockState)state).func_176734_d()), state.func_177230_c());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Blocks.field_150442_at.func_220053_a(state, worldIn, pos, context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new IProperty[]{field_185512_D, field_196366_M}));
    }

    @Override
    public Class<AnalogLeverTileEntity> getTileEntityClass() {
        return AnalogLeverTileEntity.class;
    }
}

