/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.redstone;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.goggle.IHaveGoggleInformation;
import com.simibubi.create.modules.contraptions.redstone.AnalogLeverBlock;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;

public class AnalogLeverTileEntity
extends SmartTileEntity
implements IHaveGoggleInformation {
    int state = 0;
    int lastChange;
    InterpolatedChasingValue clientState = new InterpolatedChasingValue().withSpeed(0.2f);

    public AnalogLeverTileEntity() {
        super(AllTileEntities.ANALOG_LEVER.type);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("State", this.state);
        compound.func_74768_a("ChangeTimer", this.lastChange);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.state = compound.func_74762_e("State");
        this.lastChange = compound.func_74762_e("ChangeTimer");
        this.clientState.target(this.state);
        super.func_145839_a(compound);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.lastChange > 0) {
            --this.lastChange;
            if (this.lastChange == 0) {
                this.updateOutput();
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.clientState.tick();
        }
    }

    private void updateOutput() {
        AnalogLeverBlock.updateNeighbors(this.func_195044_w(), this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void changeState(boolean back) {
        int prevState = this.state;
        this.state += back ? -1 : 1;
        this.state = MathHelper.func_76125_a((int)this.state, (int)0, (int)15);
        if (prevState != this.state) {
            this.lastChange = 15;
        }
        this.sendData();
    }

    @Override
    public boolean addToGoggleTooltip(List<String> tooltip, boolean isPlayerSneaking) {
        tooltip.add("    " + Lang.translate("tooltip.analogStrength", this.state));
        return true;
    }

    public int getState() {
        return this.state;
    }
}

