/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.redstone;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.block.SafeTileEntityRendererFast;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.modules.contraptions.redstone.AnalogLeverBlock;
import com.simibubi.create.modules.contraptions.redstone.AnalogLeverTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.world.IEnviromentBlockReader;

public class AnalogLeverTileEntityRenderer
extends SafeTileEntityRendererFast<AnalogLeverTileEntity> {
    @Override
    public void renderFast(AnalogLeverTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        BlockState leverState = te.func_195044_w();
        int lightCoords = leverState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), te.func_174877_v());
        float state = te.clientState.get(partialTicks);
        SuperByteBuffer handle = AllBlockPartials.ANALOG_LEVER_HANDLE.renderOn(leverState);
        float angle = (float)((double)(state / 15.0f * 90.0f / 180.0f) * Math.PI);
        handle.translate(-0.5f, -0.0625f, -0.5f).rotate(Direction.Axis.X, angle).translate(0.5f, 0.0625f, 0.5f);
        this.transform(handle, leverState).light(lightCoords).translate(x, y, z).renderInto(buffer);
        int color = ColorHelper.mixColors(2884352, 0xCD0000, state / 15.0f);
        SuperByteBuffer indicator = this.transform(AllBlockPartials.ANALOG_LEVER_INDICATOR.renderOn(leverState), leverState);
        indicator.light(lightCoords).translate(x, y, z).color(color).renderInto(buffer);
    }

    private SuperByteBuffer transform(SuperByteBuffer buffer, BlockState leverState) {
        AttachFace face = (AttachFace)leverState.func_177229_b((IProperty)AnalogLeverBlock.field_196366_M);
        float rX = face == AttachFace.FLOOR ? 0.0f : (face == AttachFace.WALL ? 90.0f : 180.0f);
        float rY = AngleHelper.horizontalAngle((Direction)leverState.func_177229_b((IProperty)AnalogLeverBlock.field_185512_D));
        buffer.rotateCentered(Direction.Axis.X, (float)((double)(rX / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.Axis.Y, (float)((double)(rY / 180.0f) * Math.PI));
        return buffer;
    }
}

