/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.advanced;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.RotationPropagator;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.components.motor.MotorTileEntity;
import com.simibubi.create.modules.contraptions.relays.advanced.SpeedControllerBlock;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;

public class SpeedControllerTileEntity
extends KineticTileEntity {
    public static final int DEFAULT_SPEED = 16;
    protected ScrollValueBehaviour targetSpeed;

    public SpeedControllerTileEntity() {
        super(AllTileEntities.ROTATION_SPEED_CONTROLLER.type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        Integer max = (Integer)AllConfigs.SERVER.kinetics.maxRotationSpeed.get();
        this.targetSpeed = new ScrollValueBehaviour(Lang.translate("generic.speed", new Object[0]), this, new ControllerValueBoxTransform());
        this.targetSpeed.between(-max.intValue(), max);
        this.targetSpeed.value = 16;
        this.targetSpeed.moveText(new Vec3d(9.0, 0.0, 10.0));
        this.targetSpeed.withUnit(i -> Lang.translate("generic.unit.rpm", new Object[0]));
        this.targetSpeed.withCallback(i -> this.updateTargetRotation());
        this.targetSpeed.withStepFunction(MotorTileEntity::step);
        behaviours.add(this.targetSpeed);
    }

    private void updateTargetRotation() {
        if (this.hasNetwork()) {
            this.getOrCreateNetwork().remove(this);
        }
        RotationPropagator.handleRemoved(this.field_145850_b, this.field_174879_c, this);
        this.removeSource();
        this.attachKinetics();
    }

    @Override
    public boolean hasFastRenderer() {
        return false;
    }

    public static float getConveyedSpeed(KineticTileEntity cogWheel, KineticTileEntity speedControllerIn, boolean targetingController) {
        float compareSpeed;
        if (!(speedControllerIn instanceof SpeedControllerTileEntity)) {
            return 0.0f;
        }
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        float desiredOutputSpeed = SpeedControllerTileEntity.getDesiredOutputSpeed(cogWheel, speedControllerIn, targetingController);
        float f = compareSpeed = targetingController ? speed : wheelSpeed;
        if (desiredOutputSpeed >= 0.0f && compareSpeed >= 0.0f) {
            return Math.max(desiredOutputSpeed, compareSpeed);
        }
        if (desiredOutputSpeed < 0.0f && compareSpeed < 0.0f) {
            return Math.min(desiredOutputSpeed, compareSpeed);
        }
        return desiredOutputSpeed;
    }

    public static float getDesiredOutputSpeed(KineticTileEntity cogWheel, KineticTileEntity speedControllerIn, boolean targetingController) {
        SpeedControllerTileEntity speedController = (SpeedControllerTileEntity)speedControllerIn;
        float targetSpeed = speedController.targetSpeed.getValue();
        float speed = speedControllerIn.getTheoreticalSpeed();
        float wheelSpeed = cogWheel.getTheoreticalSpeed();
        if (targetSpeed == 0.0f) {
            return 0.0f;
        }
        if (targetingController && wheelSpeed == 0.0f) {
            return 0.0f;
        }
        if (!speedController.hasSource()) {
            if (targetingController) {
                return targetSpeed;
            }
            return 0.0f;
        }
        boolean wheelPowersController = speedController.source.equals((Object)cogWheel.func_174877_v());
        if (wheelPowersController) {
            if (targetingController) {
                return targetSpeed;
            }
            return wheelSpeed;
        }
        if (targetingController) {
            return speed;
        }
        return targetSpeed;
    }

    private class ControllerValueBoxTransform
    extends ValueBoxTransform.Sided {
        private ControllerValueBoxTransform() {
        }

        @Override
        protected Vec3d getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 11.5, 14.0);
        }

        @Override
        protected boolean isSideActive(BlockState state, Direction direction) {
            if (direction.func_176740_k().func_200128_b()) {
                return false;
            }
            return state.func_177229_b(SpeedControllerBlock.HORIZONTAL_AXIS) != direction.func_176740_k();
        }

        @Override
        protected float getScale() {
            return 0.275f;
        }
    }
}

