/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.advanced.sequencer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.ScreenElementRenderer;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.contraptions.relays.advanced.sequencer.ConfigureSequencedGearshiftPacket;
import com.simibubi.create.modules.contraptions.relays.advanced.sequencer.Instruction;
import com.simibubi.create.modules.contraptions.relays.advanced.sequencer.InstructionSpeedModifiers;
import com.simibubi.create.modules.contraptions.relays.advanced.sequencer.SequencedGearshiftTileEntity;
import com.simibubi.create.modules.contraptions.relays.advanced.sequencer.SequencerInstructions;
import java.util.Vector;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;

public class SequencedGearshiftScreen
extends AbstractSimiScreen {
    private static final ItemStack renderedItem = new ItemStack((IItemProvider)AllBlocks.SEQUENCED_GEARSHIFT.get());
    private static final ScreenResources background = ScreenResources.SEQUENCER;
    private final String title = Lang.translate("gui.sequenced_gearshift.title", new Object[0]);
    private ListNBT compareTag;
    private Vector<Instruction> instructions;
    private BlockPos pos;
    private Vector<Vector<ScrollInput>> inputs;

    public SequencedGearshiftScreen(SequencedGearshiftTileEntity te) {
        this.instructions = te.instructions;
        this.pos = te.func_174877_v();
        this.compareTag = Instruction.serializeAll(this.instructions);
    }

    protected void init() {
        int row;
        this.setWindowSize(SequencedGearshiftScreen.background.width + 50, SequencedGearshiftScreen.background.height);
        super.init();
        this.widgets.clear();
        this.inputs = new Vector(5);
        for (row = 0; row < this.inputs.capacity(); ++row) {
            this.inputs.add(new Vector(3));
        }
        for (row = 0; row < this.instructions.size(); ++row) {
            this.initInputsOfRow(row);
        }
    }

    public void initInputsOfRow(int row) {
        int x = this.guiLeft + 28;
        int y = this.guiTop + 29;
        int rowHeight = 18;
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        rowInputs.forEach(this.widgets::remove);
        rowInputs.clear();
        int index = row;
        Instruction instruction = this.instructions.get(row);
        ScrollInput type = new SelectionScrollInput(x, y + rowHeight * row, 50, 14).forOptions(SequencerInstructions.getOptions()).calling(state -> this.instructionUpdated(index, (int)state)).setState(instruction.instruction.ordinal()).titled(Lang.translate("gui.sequenced_gearshift.instruction", new Object[0]));
        ScrollInput value = new ScrollInput(x + 54, y + rowHeight * row, 30, 14).calling(state -> {
            instruction.value = state;
        });
        ScrollInput direction = new SelectionScrollInput(x + 88, y + rowHeight * row, 18, 14).forOptions(InstructionSpeedModifiers.getOptions()).calling(state -> {
            instruction.speedModifier = InstructionSpeedModifiers.values()[state];
        }).titled(Lang.translate("gui.sequenced_gearshift.speed", new Object[0]));
        rowInputs.add(type);
        rowInputs.add(value);
        rowInputs.add(direction);
        this.widgets.addAll(rowInputs);
        this.updateParamsOfRow(row);
    }

    public void updateParamsOfRow(int row) {
        Instruction instruction = this.instructions.get(row);
        Vector<ScrollInput> rowInputs = this.inputs.get(row);
        SequencerInstructions def = instruction.instruction;
        boolean hasValue = def.hasValueParameter;
        boolean hasModifier = def.hasSpeedParameter;
        ScrollInput value = rowInputs.get(1);
        value.active = value.visible = hasValue;
        if (hasValue) {
            value.withRange(1, def.maxValue + 1).titled(Lang.translate(def.parameterKey, new Object[0])).withShiftStep(def.shiftStep).setState(instruction.value).onChanged();
        }
        if (def == SequencerInstructions.WAIT) {
            value.withStepFunction(context -> {
                int v = context.currentValue;
                if (!context.forward) {
                    --v;
                }
                if (v < 20) {
                    return context.shift ? 20 : 1;
                }
                return context.shift ? 100 : 20;
            });
        } else {
            value.withStepFunction(value.standardStep());
        }
        ScrollInput modifier = rowInputs.get(2);
        modifier.active = modifier.visible = hasModifier;
        if (hasModifier) {
            modifier.setState(instruction.speedModifier.ordinal());
        }
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int hFontColor = 13880254;
        background.draw((AbstractGui)this, this.guiLeft, this.guiTop);
        for (int row = 0; row < this.instructions.capacity(); ++row) {
            ScreenResources toDraw = ScreenResources.SEQUENCER_EMPTY;
            int yOffset = toDraw.height * row;
            if (row < this.instructions.size()) {
                Instruction instruction = this.instructions.get(row);
                SequencerInstructions def = instruction.instruction;
                def.background.draw(this.guiLeft + 14, this.guiTop + 29 + yOffset);
                this.label(32, 6 + yOffset, Lang.translate(def.translationKey, new Object[0]));
                if (def.hasValueParameter) {
                    String text = def.formatValue(instruction.value);
                    int stringWidth = this.font.func_78256_a(text);
                    this.label(85 + (12 - stringWidth / 2), 6 + yOffset, text);
                }
                if (!def.hasSpeedParameter) continue;
                this.label(120, 6 + yOffset, instruction.speedModifier.label);
                continue;
            }
            toDraw.draw(this.guiLeft + 14, this.guiTop + 29 + yOffset);
        }
        this.font.func_175063_a(this.title, (float)(this.guiLeft - 3 + (SequencedGearshiftScreen.background.width - this.font.func_78256_a(this.title)) / 2), (float)(this.guiTop + 10), hFontColor);
        ScreenElementRenderer.render3DItem(this::getRenderedBlock);
    }

    private void label(int x, int y, String text) {
        this.font.func_175063_a(text, (float)(this.guiLeft + x), (float)(this.guiTop + 26 + y), 0xFFFFEE);
    }

    public void sendPacket() {
        ListNBT serialized = Instruction.serializeAll(this.instructions);
        if (serialized.equals((Object)this.compareTag)) {
            return;
        }
        AllPackets.channel.sendToServer((Object)new ConfigureSequencedGearshiftPacket(this.pos, serialized));
    }

    public void removed() {
        this.sendPacket();
    }

    public ItemStack getRenderedBlock() {
        GlStateManager.translated((double)(this.guiLeft + SequencedGearshiftScreen.background.width + 20), (double)(this.guiTop + 50), (double)0.0);
        GlStateManager.scaled((double)5.0, (double)5.0, (double)5.0);
        return renderedItem;
    }

    private void instructionUpdated(int index, int state) {
        SequencerInstructions newValue;
        this.instructions.get((int)index).instruction = newValue = SequencerInstructions.values()[state];
        this.instructions.get((int)index).value = newValue.defaultValue;
        this.updateParamsOfRow(index);
        if (newValue == SequencerInstructions.END) {
            for (int i = this.instructions.size() - 1; i > index; --i) {
                this.instructions.remove(i);
                Vector<ScrollInput> rowInputs = this.inputs.get(i);
                rowInputs.forEach(this.widgets::remove);
                rowInputs.clear();
            }
        } else if (index + 1 < this.instructions.capacity() && index + 1 == this.instructions.size()) {
            this.instructions.add(new Instruction(SequencerInstructions.END));
            this.initInputsOfRow(index + 1);
        }
    }
}

