/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.belt;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.modules.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.contraptions.relays.belt.transport.TransportedItemStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public enum AllBeltAttachments {
    BELT_FUNNEL(AllBlocks.BELT_FUNNEL),
    BELT_OBSERVER(AllBlocks.ENTITY_DETECTOR),
    MECHANICAL_PRESS(AllBlocks.MECHANICAL_PRESS),
    LOGISTICAL_ATTACHABLES(AllBlocks.EXTRACTOR);

    IBeltAttachment attachment;

    private AllBeltAttachments(AllBlocks attachment) {
        this.attachment = (IBeltAttachment)attachment.get();
    }

    public static class Tracker {
        public List<BeltAttachmentState> attachments = new LinkedList<BeltAttachmentState>();
        private BeltTileEntity te;

        public Tracker(BeltTileEntity te) {
            this.te = te;
        }

        public void findAttachments(BeltTileEntity belt) {
            for (AllBeltAttachments ba : AllBeltAttachments.values()) {
                World world = belt.func_145831_w();
                BlockPos beltPos = belt.func_174877_v();
                BlockState beltState = belt.func_195044_w();
                List<BlockPos> attachmentPositions = ba.attachment.getPotentialAttachmentPositions((IWorld)world, beltPos, beltState);
                for (BlockPos potentialPos : attachmentPositions) {
                    IBeltAttachment attachment;
                    BlockState state;
                    if (!world.func_195588_v(potentialPos) || !((state = world.func_180495_p(potentialPos)).func_177230_c() instanceof IBeltAttachment) || !(attachment = (IBeltAttachment)state.func_177230_c()).getBeltPositionForAttachment((IWorld)world, potentialPos, state).equals((Object)beltPos) || !attachment.isAttachedCorrectly((IWorld)world, potentialPos, beltPos, state, beltState)) continue;
                    this.addAttachment((IWorld)world, potentialPos);
                }
            }
        }

        public BeltAttachmentState addAttachment(IWorld world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            this.removeAttachment(pos);
            if (!(state.func_177230_c() instanceof IBeltAttachment)) {
                Create.logger.warn("Missing belt attachment for Belt at " + pos.toString());
                return null;
            }
            BeltAttachmentState newAttachmentState = new BeltAttachmentState((IBeltAttachment)state.func_177230_c(), pos);
            this.attachments.add(newAttachmentState);
            this.te.func_70296_d();
            return newAttachmentState;
        }

        public void removeAttachment(BlockPos pos) {
            BeltAttachmentState toRemove = null;
            for (BeltAttachmentState atState : this.attachments) {
                if (!atState.attachmentPos.equals((Object)pos)) continue;
                toRemove = atState;
            }
            if (toRemove != null) {
                this.attachments.remove(toRemove);
            }
            this.te.func_70296_d();
        }

        public void forEachAttachment(Consumer<BeltAttachmentState> consumer) {
            this.attachments.forEach(consumer::accept);
        }

        public void readAndSearch(CompoundNBT nbt, BeltTileEntity belt) {
            this.attachments.clear();
            if (!nbt.func_74764_b("HasAttachments")) {
                this.findAttachments(belt);
                return;
            }
            if (nbt.func_74764_b("AttachmentData")) {
                ListNBT list = (ListNBT)nbt.func_74781_a("AttachmentData");
                for (INBT data : list) {
                    CompoundNBT stateNBT = (CompoundNBT)data;
                    BlockPos attachmentPos = NBTUtil.func_186861_c((CompoundNBT)stateNBT.func_74775_l("Position"));
                    BeltAttachmentState atState = this.addAttachment((IWorld)belt.func_145831_w(), attachmentPos);
                    if (atState == null) continue;
                    atState.processingDuration = stateNBT.func_74762_e("Duration");
                }
            }
        }

        public void write(CompoundNBT nbt) {
            if (!this.attachments.isEmpty()) {
                nbt.func_74757_a("HasAttachments", true);
                ListNBT list = new ListNBT();
                this.forEachAttachment(atState -> {
                    CompoundNBT stateNBT = new CompoundNBT();
                    stateNBT.func_218657_a("Position", (INBT)NBTUtil.func_186859_a((BlockPos)atState.attachmentPos));
                    stateNBT.func_74768_a("Duration", atState.processingDuration);
                    list.add((Object)stateNBT);
                });
                nbt.func_218657_a("AttachmentData", (INBT)list);
            }
        }
    }

    public static class BeltAttachmentState {
        public IBeltAttachment attachment;
        public BlockPos attachmentPos;
        public int processingDuration;
        public Entity processingEntity;
        public TransportedItemStack processingStack;

        public BeltAttachmentState(IBeltAttachment attachment, BlockPos attachmentPos) {
            this.attachment = attachment;
            this.attachmentPos = attachmentPos;
        }
    }

    public static interface IBeltAttachment {
        public List<BlockPos> getPotentialAttachmentPositions(IWorld var1, BlockPos var2, BlockState var3);

        public BlockPos getBeltPositionForAttachment(IWorld var1, BlockPos var2, BlockState var3);

        default public boolean isAttachedCorrectly(IWorld world, BlockPos attachmentPos, BlockPos beltPos, BlockState attachmentState, BlockState beltState) {
            return true;
        }

        default public boolean processEntity(BeltTileEntity te, Entity entity, BeltAttachmentState state) {
            return false;
        }

        default public boolean startProcessingItem(BeltTileEntity te, TransportedItemStack transported, BeltAttachmentState state) {
            return false;
        }

        default public boolean processItem(BeltTileEntity te, TransportedItemStack transported, BeltAttachmentState state) {
            return false;
        }

        default public void onAttachmentPlaced(IWorld world, BlockPos pos, BlockState state) {
            BlockPos beltPos = this.getBeltPositionForAttachment(world, pos, state);
            BeltTileEntity belt = BeltHelper.getSegmentTE(world, beltPos);
            if (belt == null) {
                return;
            }
            if (!this.isAttachedCorrectly(world, pos, beltPos, state, world.func_180495_p(beltPos))) {
                return;
            }
            belt.attachmentTracker.addAttachment(world, pos);
            belt.func_70296_d();
            belt.sendData();
        }

        default public void onAttachmentRemoved(IWorld world, BlockPos pos, BlockState state) {
            BlockPos beltPos = this.getBeltPositionForAttachment(world, pos, state);
            BeltTileEntity belt = BeltHelper.getSegmentTE(world, beltPos);
            if (belt == null) {
                return;
            }
            if (!this.isAttachedCorrectly(world, pos, beltPos, state, world.func_180495_p(beltPos))) {
                return;
            }
            belt.attachmentTracker.removeAttachment(pos);
            belt.func_70296_d();
            belt.sendData();
        }
    }
}

