/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.belt;

import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;

public class BeltHelper {
    public static BeltTileEntity getSegmentTE(IWorld world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 0)) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)tileEntity;
    }

    public static BeltTileEntity getControllerTE(IWorld world, BlockPos pos) {
        BeltTileEntity segment = BeltHelper.getSegmentTE(world, pos);
        if (segment == null) {
            return null;
        }
        BlockPos controllerPos = segment.controller;
        if (controllerPos == null) {
            return null;
        }
        return BeltHelper.getSegmentTE(world, controllerPos);
    }

    public static BeltTileEntity getBeltAtSegment(BeltTileEntity controller, int segment) {
        BlockPos pos = BeltHelper.getPositionForOffset(controller, segment);
        TileEntity te = controller.func_145831_w().func_175625_s(pos);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return null;
        }
        return (BeltTileEntity)te;
    }

    public static BlockPos getPositionForOffset(BeltTileEntity controller, int offset) {
        BlockPos pos = controller.func_174877_v();
        Vec3i vec = controller.getBeltFacing().func_176730_m();
        BeltBlock.Slope slope = (BeltBlock.Slope)((Object)controller.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltBlock.Slope.DOWNWARD ? -1 : (slope == BeltBlock.Slope.UPWARD ? 1 : 0);
        return pos.func_177982_a(offset * vec.func_177958_n(), MathHelper.func_76125_a((int)offset, (int)0, (int)(controller.beltLength - 1)) * verticality, offset * vec.func_177952_p());
    }

    public static Vec3d getVectorForOffset(BeltTileEntity controller, float offset) {
        BeltBlock.Slope slope = (BeltBlock.Slope)((Object)controller.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltBlock.Slope.DOWNWARD ? -1 : (slope == BeltBlock.Slope.UPWARD ? 1 : 0);
        float verticalMovement = verticality;
        if ((double)offset < 0.5) {
            verticalMovement = 0.0f;
        }
        verticalMovement *= Math.min(offset, (float)controller.beltLength - 0.5f) - 0.5f;
        Vec3d vec = VecHelper.getCenterOf((Vec3i)controller.func_174877_v());
        Vec3d horizontalMovement = new Vec3d(controller.getBeltFacing().func_176730_m()).func_186678_a((double)(offset - 0.5f));
        if (slope == BeltBlock.Slope.VERTICAL) {
            horizontalMovement = Vec3d.field_186680_a;
        }
        vec = vec.func_178787_e(horizontalMovement).func_72441_c(0.0, (double)verticalMovement, 0.0);
        return vec;
    }
}

