/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.belt;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.block.SafeTileEntityRenderer;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.block.render.SpriteShifter;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.IndependentShadowRenderer;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.contraptions.relays.belt.transport.TransportedItemStack;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;

public class BeltTileEntityRenderer
extends SafeTileEntityRenderer<BeltTileEntity> {
    private static SpriteShiftEntry animatedTexture;

    @Override
    public void renderWithGL(BeltTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        TessellatorHelper.prepareFastRender();
        TessellatorHelper.begin(DefaultVertexFormats.field_176600_a);
        this.renderTileEntityFast(te, x, y, z, partialTicks, destroyStage, Tessellator.func_178181_a().func_178180_c());
        TessellatorHelper.draw();
        this.renderItems(te, x, y, z, partialTicks);
    }

    @Override
    public void renderFast(BeltTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        BlockState blockState = te.func_195044_w();
        if (!AllBlocks.BELT.typeOf(blockState)) {
            return;
        }
        BlockState renderedState = this.getBeltState(te);
        SuperByteBuffer beltBuffer = CreateClient.bufferCache.renderBlockIn(KineticTileEntityRenderer.KINETIC_TILE, renderedState);
        beltBuffer.color(te.color == -1 ? 0x808080 : te.color);
        float speed = te.getSpeed();
        if (animatedTexture == null) {
            animatedTexture = SpriteShifter.get("block/belt", "block/belt_animated");
        }
        if (speed != 0.0f) {
            int textureIndex;
            float time = AnimationTickHolder.getRenderTick() * (float)((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176743_c().func_179524_a();
            if (((Direction)renderedState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() == Direction.Axis.X) {
                speed = -speed;
            }
            if ((textureIndex = (int)(speed * time / 36.0f % 16.0f)) < 0) {
                textureIndex += 16;
            }
            beltBuffer.shiftUVtoSheet(animatedTexture, (float)(textureIndex % 4) / 4.0f, (float)(textureIndex / 4) / 4.0f, 4);
        } else {
            beltBuffer.dontShiftUV();
        }
        int packedLightmapCoords = blockState.func_215684_a((IEnviromentBlockReader)this.func_178459_a(), te.func_174877_v());
        beltBuffer.light(packedLightmapCoords).translate(x, y, z).renderInto(buffer);
        if (te.hasPulley()) {
            SuperByteBuffer superBuffer = AllBlockPartials.BELT_PULLEY.renderOn(blockState);
            Direction.Axis axis = ((Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k();
            superBuffer.rotateCentered(Direction.Axis.X, 1.5707964f);
            superBuffer.rotateCentered(Direction.Axis.Y, (float)(axis == Direction.Axis.X ? 0.0 : 1.5707963267948966));
            KineticTileEntityRenderer.standardKineticRotationTransform(superBuffer, te, this.func_178459_a()).translate(x, y, z).renderInto(buffer);
        }
    }

    protected void renderItems(BeltTileEntity te, double x, double y, double z, float partialTicks) {
        if (!te.isController()) {
            return;
        }
        if (te.beltLength == 0) {
            return;
        }
        GlStateManager.pushMatrix();
        Vec3i directionVec = te.getBeltFacing().func_176730_m();
        Vec3d beltStartOffset = new Vec3d(directionVec).func_186678_a(-0.5).func_72441_c(0.5, 0.9375, 0.5);
        GlStateManager.translated((double)(x + beltStartOffset.field_72450_a), (double)(y + beltStartOffset.field_72448_b), (double)(z + beltStartOffset.field_72449_c));
        BeltBlock.Slope slope = (BeltBlock.Slope)((Object)te.func_195044_w().func_177229_b(BeltBlock.SLOPE));
        int verticality = slope == BeltBlock.Slope.DOWNWARD ? -1 : (slope == BeltBlock.Slope.UPWARD ? 1 : 0);
        boolean slopeAlongX = te.getBeltFacing().func_176740_k() == Direction.Axis.X;
        for (TransportedItemStack transported : te.getInventory().getItems()) {
            boolean alongX;
            boolean tiltForward;
            GlStateManager.pushMatrix();
            TessellatorHelper.fightZFighting(transported.angle);
            float offset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
            float sideOffset = MathHelper.func_219799_g((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            float verticalMovement = verticality;
            if (te.getSpeed() == 0.0f) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            }
            if ((double)offset < 0.5) {
                verticalMovement = 0.0f;
            }
            Vec3d offsetVec = new Vec3d(directionVec).func_186678_a((double)offset).func_72441_c(0.0, (double)(verticalMovement *= Math.min(offset, (float)te.beltLength - 0.5f) - 0.5f), 0.0);
            boolean onSlope = slope != BeltBlock.Slope.HORIZONTAL && MathHelper.func_76131_a((float)offset, (float)0.5f, (float)((float)te.beltLength - 0.5f)) == offset;
            boolean bl = tiltForward = (slope == BeltBlock.Slope.DOWNWARD ^ te.getBeltFacing().func_176743_c() == Direction.AxisDirection.POSITIVE) == (te.getBeltFacing().func_176740_k() == Direction.Axis.Z);
            float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
            GlStateManager.translated((double)offsetVec.field_72450_a, (double)offsetVec.field_72448_b, (double)offsetVec.field_72449_c);
            boolean bl2 = alongX = te.getBeltFacing().func_176746_e().func_176740_k() == Direction.Axis.X;
            if (!alongX) {
                sideOffset *= -1.0f;
            }
            GlStateManager.translated((double)(alongX ? (double)sideOffset : 0.0), (double)0.0, (double)(alongX ? 0.0 : (double)sideOffset));
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            boolean blockItem = itemRenderer.func_204206_b(transported.stack).func_177556_c();
            if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                Vec3d shadowPos = new Vec3d((Vec3i)te.func_174877_v()).func_178787_e(beltStartOffset.func_186678_a(1.0).func_178787_e(offsetVec).func_72441_c(alongX ? (double)sideOffset : 0.0, 0.39, alongX ? 0.0 : (double)sideOffset));
                IndependentShadowRenderer.renderShadow(shadowPos.field_72450_a, shadowPos.field_72448_b, shadowPos.field_72449_c, 0.75f, blockItem ? 0.2f : 0.2f);
            }
            RenderHelper.func_74519_b();
            int count = MathHelper.func_151239_c((int)transported.stack.func_190916_E()) / 2;
            GlStateManager.rotated((double)slopeAngle, (double)(slopeAlongX ? 0.0 : 1.0), (double)0.0, (double)(slopeAlongX ? 1.0 : 0.0));
            if (onSlope) {
                GlStateManager.translated((double)0.0, (double)0.125, (double)0.0);
            }
            Random r = new Random(transported.angle);
            for (int i = 0; i <= count; ++i) {
                GlStateManager.pushMatrix();
                GlStateManager.rotated((double)transported.angle, (double)0.0, (double)1.0, (double)0.0);
                if (!blockItem) {
                    GlStateManager.translated((double)0.0, (double)-0.09375, (double)0.0);
                    GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                }
                if (blockItem) {
                    GlStateManager.translated((double)(r.nextFloat() * 0.0625f * (float)i), (double)0.0, (double)(r.nextFloat() * 0.0625f * (float)i));
                }
                GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
                itemRenderer.func_181564_a(transported.stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.popMatrix();
                if (!blockItem) {
                    GlStateManager.rotated((double)10.0, (double)0.0, (double)1.0, (double)0.0);
                }
                GlStateManager.translated((double)0.0, (double)(blockItem ? 0.015625 : 0.0625), (double)0.0);
            }
            RenderHelper.func_74518_a();
            GlStateManager.popMatrix();
        }
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    protected BlockState getBeltState(KineticTileEntity te) {
        return (BlockState)te.func_195044_w().func_206870_a((IProperty)BeltBlock.CASING, (Comparable)Boolean.valueOf(false));
    }
}

