/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.belt.item;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.item.IAddedByOther;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.contraptions.relays.elementary.ShaftBlock;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BeltConnectorItem
extends BlockItem
implements IAddedByOther {
    public BeltConnectorItem(Item.Properties properties) {
        super(AllBlocks.BELT.get(), properties);
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195998_g()) {
            context.func_195996_i().func_77982_d(null);
            return ActionResultType.SUCCESS;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        boolean validAxis = BeltConnectorItem.validateAxis(world, pos);
        if (world.field_72995_K) {
            return validAxis ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        CompoundNBT tag = context.func_195996_i().func_196082_o();
        BlockPos firstPulley = null;
        if (tag.func_74764_b("FirstPulley") && !BeltConnectorItem.validateAxis(world, firstPulley = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("FirstPulley")))) {
            tag.func_82580_o("FirstPulley");
            context.func_195996_i().func_77982_d(tag);
        }
        if (!validAxis) {
            return ActionResultType.FAIL;
        }
        if (tag.func_74764_b("FirstPulley")) {
            if (!BeltConnectorItem.canConnect(world, firstPulley, pos)) {
                return ActionResultType.FAIL;
            }
            if (firstPulley != null && !firstPulley.equals((Object)pos) && !world.field_72995_K) {
                BeltConnectorItem.createBelts(world, firstPulley, pos);
                AllTriggers.triggerFor(AllTriggers.CONNECT_BELT, context.func_195999_j());
                if (!context.func_195999_j().func_184812_l_()) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
            if (!context.func_195996_i().func_190926_b()) {
                context.func_195996_i().func_77982_d(null);
                context.func_195999_j().func_184811_cZ().func_185145_a((Item)this, 5);
            }
            return ActionResultType.SUCCESS;
        }
        tag.func_218657_a("FirstPulley", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        context.func_195996_i().func_77982_d(tag);
        context.func_195999_j().func_184811_cZ().func_185145_a((Item)this, 5);
        return ActionResultType.SUCCESS;
    }

    public static void createBelts(World world, BlockPos start, BlockPos end) {
        BeltBlock.Slope slope = BeltConnectorItem.getSlopeBetween(start, end);
        Direction facing = BeltConnectorItem.getFacingFromTo(start, end);
        BlockPos diff = end.func_177973_b((Vec3i)start);
        if (diff.func_177958_n() == diff.func_177952_p()) {
            facing = Direction.func_181076_a((Direction.AxisDirection)facing.func_176743_c(), (Direction.Axis)(world.func_180495_p(start).func_177229_b((IProperty)BlockStateProperties.field_208148_A) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        List<BlockPos> beltsToCreate = BeltConnectorItem.getBeltChainBetween(start, end, slope, facing);
        BlockState beltBlock = AllBlocks.BELT.get().func_176223_P();
        for (BlockPos pos : beltsToCreate) {
            BeltBlock.Part part = pos.equals((Object)start) ? BeltBlock.Part.START : (pos.equals((Object)end) ? BeltBlock.Part.END : BeltBlock.Part.MIDDLE);
            boolean pulley = AllBlocks.SHAFT.typeOf(world.func_180495_p(pos));
            if (part == BeltBlock.Part.MIDDLE && pulley) {
                part = BeltBlock.Part.PULLEY;
            }
            world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)beltBlock.func_206870_a(BeltBlock.SLOPE, (Comparable)((Object)slope))).func_206870_a(BeltBlock.PART, (Comparable)((Object)part))).func_206870_a(BeltBlock.HORIZONTAL_FACING, (Comparable)facing), 3);
        }
    }

    private static Direction getFacingFromTo(BlockPos start, BlockPos end) {
        Direction.Axis beltAxis = start.func_177958_n() == end.func_177958_n() ? Direction.Axis.Z : Direction.Axis.X;
        BlockPos diff = end.func_177973_b((Vec3i)start);
        Direction.AxisDirection axisDirection = Direction.AxisDirection.POSITIVE;
        axisDirection = diff.func_177958_n() == 0 && diff.func_177952_p() == 0 ? (diff.func_177956_o() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE) : (beltAxis.func_196052_a(diff.func_177958_n(), 0, diff.func_177952_p()) > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE);
        return Direction.func_181076_a((Direction.AxisDirection)axisDirection, (Direction.Axis)beltAxis);
    }

    private static BeltBlock.Slope getSlopeBetween(BlockPos start, BlockPos end) {
        BlockPos diff = end.func_177973_b((Vec3i)start);
        if (diff.func_177956_o() != 0) {
            if (diff.func_177952_p() != 0 || diff.func_177958_n() != 0) {
                return diff.func_177956_o() > 0 ? BeltBlock.Slope.UPWARD : BeltBlock.Slope.DOWNWARD;
            }
            return BeltBlock.Slope.VERTICAL;
        }
        return BeltBlock.Slope.HORIZONTAL;
    }

    private static List<BlockPos> getBeltChainBetween(BlockPos start, BlockPos end, BeltBlock.Slope slope, Direction direction) {
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        int limit = 1000;
        BlockPos current = start;
        do {
            positions.add(current);
            if (slope == BeltBlock.Slope.VERTICAL) {
                current = current.func_177981_b(direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : -1);
                continue;
            }
            current = current.func_177972_a(direction);
            if (slope == BeltBlock.Slope.HORIZONTAL) continue;
            current = current.func_177981_b(slope == BeltBlock.Slope.UPWARD ? 1 : -1);
        } while (!current.equals((Object)end) && limit-- > 0);
        positions.add(end);
        return positions;
    }

    public static boolean canConnect(World world, BlockPos first, BlockPos second) {
        if (!world.isAreaLoaded(first, 1)) {
            return false;
        }
        if (!world.isAreaLoaded(second, 1)) {
            return false;
        }
        if (!second.func_218141_a((Vec3i)first, (double)((Integer)AllConfigs.SERVER.kinetics.maxBeltLength.get()).intValue())) {
            return false;
        }
        BlockPos diff = second.func_177973_b((Vec3i)first);
        Direction.Axis axis = (Direction.Axis)world.func_180495_p(first).func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        int x = diff.func_177958_n();
        int y = diff.func_177956_o();
        int z = diff.func_177952_p();
        int sames = (Math.abs(x) == Math.abs(y) ? 1 : 0) + (Math.abs(y) == Math.abs(z) ? 1 : 0) + (Math.abs(z) == Math.abs(x) ? 1 : 0);
        if (axis.func_196052_a(x, y, z) != 0) {
            return false;
        }
        if (sames != 1) {
            return false;
        }
        if (axis != world.func_180495_p(second).func_177229_b((IProperty)BlockStateProperties.field_208148_A)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(first);
        TileEntity tileEntity2 = world.func_175625_s(second);
        if (!(tileEntity instanceof KineticTileEntity)) {
            return false;
        }
        if (!(tileEntity2 instanceof KineticTileEntity)) {
            return false;
        }
        float speed1 = ((KineticTileEntity)tileEntity).getTheoreticalSpeed();
        float speed2 = ((KineticTileEntity)tileEntity2).getTheoreticalSpeed();
        if (Math.signum(speed1) != Math.signum(speed2) && speed1 != 0.0f && speed2 != 0.0f) {
            return false;
        }
        BlockPos step = new BlockPos((double)Math.signum(diff.func_177958_n()), (double)Math.signum(diff.func_177956_o()), (double)Math.signum(diff.func_177952_p()));
        int limit = 1000;
        BlockPos currentPos = first.func_177971_a((Vec3i)step);
        while (!currentPos.equals((Object)second) && limit-- > 0) {
            BlockState blockState = world.func_180495_p(currentPos);
            if (!(AllBlocks.SHAFT.typeOf(blockState) && blockState.func_177229_b((IProperty)ShaftBlock.AXIS) == axis || blockState.func_185904_a().func_76222_j())) {
                return false;
            }
            currentPos = currentPos.func_177971_a((Vec3i)step);
        }
        return true;
    }

    public static boolean validateAxis(World world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        if (!AllBlocks.SHAFT.typeOf(world.func_180495_p(pos))) {
            return false;
        }
        return world.func_180495_p(pos).func_177229_b((IProperty)BlockStateProperties.field_208148_A) != Direction.Axis.Y;
    }
}

