/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.elementary;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.IHaveCustomBlockItem;
import com.simibubi.create.foundation.utility.AllShapes;
import com.simibubi.create.modules.contraptions.base.IRotate;
import com.simibubi.create.modules.contraptions.relays.advanced.SpeedControllerBlock;
import com.simibubi.create.modules.contraptions.relays.elementary.CogwheelBlockItem;
import com.simibubi.create.modules.contraptions.relays.elementary.ShaftBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class CogWheelBlock
extends ShaftBlock
implements IHaveCustomBlockItem {
    private boolean isLarge;

    public CogWheelBlock(boolean large) {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196650_c));
        this.isLarge = large;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.func_177229_b((IProperty)AXIS));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            BlockState blockState;
            if (facing.func_176740_k() == state.func_177229_b((IProperty)AXIS) || !AllBlocks.LARGE_COGWHEEL.typeOf(blockState = worldIn.func_180495_p(pos.func_177972_a(facing))) && (!this.isLarge || !AllBlocks.COGWHEEL.typeOf(blockState))) continue;
            return false;
        }
        return true;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos placedOnPos = context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d());
        World world = context.func_195991_k();
        BlockState placedAgainst = world.func_180495_p(placedOnPos);
        Block block = placedAgainst.func_177230_c();
        BlockState stateBelow = world.func_180495_p(context.func_195995_a().func_177977_b());
        if (AllBlocks.ROTATION_SPEED_CONTROLLER.typeOf(stateBelow) && this.isLarge) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)(stateBelow.func_177229_b(SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        if (!(block instanceof IRotate) || !((IRotate)block).hasIntegratedCogwheel((IWorldReader)world, placedOnPos, placedAgainst)) {
            Direction.Axis preferredAxis = CogWheelBlock.getPreferredAxis(context);
            if (preferredAxis != null) {
                return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)preferredAxis);
            }
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)context.func_196000_l().func_176740_k());
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)AXIS, (Comparable)((IRotate)block).getRotationAxis(placedAgainst));
    }

    @Override
    public float getParticleTargetRadius() {
        return this.isLarge ? 1.125f : 0.65f;
    }

    @Override
    public float getParticleInitialRadius() {
        return this.isLarge ? 1.0f : 0.75f;
    }

    @Override
    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((IItemProvider)this));
    }

    @Override
    public boolean hasIntegratedCogwheel(IWorldReader world, BlockPos pos, BlockState state) {
        return !this.isLarge;
    }

    @Override
    public BlockItem getCustomItem(Item.Properties properties) {
        return new CogwheelBlockItem(this, properties, this.isLarge);
    }
}

