/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.contraptions.relays.gearbox;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.base.KineticTileEntityRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class GearboxTileEntityRenderer
extends KineticTileEntityRenderer {
    @Override
    public void renderFast(KineticTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        Direction.Axis boxAxis = (Direction.Axis)te.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208148_A);
        BlockPos pos = te.func_174877_v();
        float time = AnimationTickHolder.getRenderTick();
        for (Direction direction : Direction.values()) {
            Direction.Axis axis = direction.func_176740_k();
            if (boxAxis == axis) continue;
            SuperByteBuffer shaft = AllBlockPartials.SHAFT_HALF.renderOnDirectional(te.func_195044_w(), direction);
            float offset = GearboxTileEntityRenderer.getRotationOffsetForPosition(te, pos, axis);
            float angle = time * te.getSpeed() * 3.0f / 10.0f % 360.0f;
            if (te.getSpeed() != 0.0f && te.hasSource()) {
                BlockPos source = te.source.func_177973_b((Vec3i)te.func_174877_v());
                Direction sourceFacing = Direction.func_176737_a((float)source.func_177958_n(), (float)source.func_177956_o(), (float)source.func_177952_p());
                if (sourceFacing.func_176740_k() == direction.func_176740_k()) {
                    angle *= sourceFacing == direction ? 1.0f : -1.0f;
                } else if (sourceFacing.func_176743_c() == direction.func_176743_c()) {
                    angle *= -1.0f;
                }
            }
            angle += offset;
            angle = angle / 180.0f * (float)Math.PI;
            GearboxTileEntityRenderer.kineticRotationTransform(shaft, te, axis, angle, this.func_178459_a());
            shaft.translate(x, y, z).renderInto(buffer);
        }
    }
}

