/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.deforester;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.block.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.IHaveCustomItemModel;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.curiosities.deforester.DeforesterModel;
import com.simibubi.create.modules.curiosities.tools.AllToolTiers;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DeforesterItem
extends AxeItem
implements IHaveCustomItemModel {
    public DeforesterItem(Item.Properties builder) {
        super((IItemTier)AllToolTiers.RADIANT, 5.0f, -3.1f, builder);
    }

    public static void destroyTree(ItemStack stack, IWorld worldIn, BlockState state, BlockPos pos, PlayerEntity player) {
        if (!state.func_203425_a(BlockTags.field_200031_h) || player.func_70093_af()) {
            return;
        }
        TreeCutter.Tree tree = TreeCutter.cutTree((IBlockReader)worldIn, pos);
        if (tree == null) {
            return;
        }
        boolean dropBlock = !player.func_184812_l_();
        World world = worldIn.func_201672_e();
        if (world == null) {
            return;
        }
        Vec3d vec = player.func_70040_Z();
        for (BlockPos log : tree.logs) {
            BlockHelper.destroyBlock(world, log, 0.5f, item -> {
                if (dropBlock) {
                    DeforesterItem.dropItemFromCutTree(world, pos, vec, log, item);
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
                }
            });
        }
        for (BlockPos leaf : tree.leaves) {
            BlockHelper.destroyBlock(world, leaf, 0.125f, item -> {
                if (dropBlock) {
                    DeforesterItem.dropItemFromCutTree(world, pos, vec, leaf, item);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().func_184614_ca();
        if (!AllItems.DEFORESTER.typeOf(heldItemMainhand)) {
            return;
        }
        DeforesterItem.destroyTree(heldItemMainhand, event.getWorld(), event.getState(), event.getPos(), event.getPlayer());
    }

    public static void dropItemFromCutTree(World world, BlockPos breakingPos, Vec3d fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.func_177951_i((Vec3i)breakingPos));
        Vec3d dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.field_72450_a, dropPos.field_72448_b, dropPos.field_72449_c, stack);
        entity.func_213317_d(fallDirection.func_186678_a((double)(distance / 20.0f)));
        world.func_217376_c((Entity)entity);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CustomRenderedItemModel createModel(IBakedModel original) {
        return new DeforesterModel(original);
    }
}

