/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.partialWindows;

import com.simibubi.create.foundation.block.IHaveCustomBlockModel;
import com.simibubi.create.foundation.block.IHaveNoBlockItem;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.modules.curiosities.partialWindows.WindowInABlockModel;
import com.simibubi.create.modules.curiosities.partialWindows.WindowInABlockTileEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WindowInABlockBlock
extends PaneBlock
implements ITE<WindowInABlockTileEntity>,
IHaveNoBlockItem,
IHaveCustomBlockModel {
    public WindowInABlockBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WindowInABlockTileEntity();
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        Vec3d end;
        if (player == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        Vec3d start = player.func_174824_e(1.0f);
        BlockRayTraceResult target = world.func_217299_a(new RayTraceContext(start, end = start.func_178787_e(player.func_70040_Z().func_186678_a(player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e())), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (target == null || target.func_216347_e() == null) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        try {
            WindowInABlockTileEntity tileEntity = (WindowInABlockTileEntity)this.getTileEntity((IBlockReader)world, pos);
            BlockState windowBlock = tileEntity.getWindowBlock();
            for (AxisAlignedBB bb : windowBlock.func_196954_c((IBlockReader)world, pos).func_197756_d()) {
                if (!bb.func_186662_g(0.1).func_72318_a(target.func_216347_e().func_178788_d(new Vec3d((Vec3i)pos)))) continue;
                windowBlock.func_177230_c().func_176208_a(world, pos, windowBlock, player);
                Block.func_220054_a((BlockState)windowBlock, (World)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.func_184614_ca());
                BlockState partialBlock = tileEntity.getPartialBlock();
                world.func_175656_a(pos, partialBlock);
                for (Direction d : Direction.values()) {
                    BlockPos offset = pos.func_177972_a(d);
                    BlockState otherState = world.func_180495_p(offset);
                    partialBlock = partialBlock.func_196956_a(d, otherState, (IWorld)world, pos, offset);
                    world.func_184138_a(offset, otherState, otherState, 2);
                }
                if (partialBlock != world.func_180495_p(pos)) {
                    world.func_175656_a(pos, partialBlock);
                }
                return false;
            }
        }
        catch (ITE.TileEntityException tileEntityException) {
            // empty catch block
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return this.getSurroundingBlockState(reader, pos).func_200131_a(reader, pos);
    }

    public boolean collisionExtendsVertically(BlockState state, IBlockReader world, BlockPos pos, Entity collidingEntity) {
        return this.getSurroundingBlockState(world, pos).collisionExtendsVertically(world, pos, collidingEntity);
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return this.getSurroundingBlockState(worldIn, pos).func_185887_b(worldIn, pos);
    }

    public float getExplosionResistance(BlockState state, IWorldReader world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getSurroundingBlockState((IBlockReader)world, pos).getExplosionResistance(world, pos, exploder, explosion);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        BlockState window = this.getWindowBlockState(world, pos);
        for (AxisAlignedBB bb : window.func_196954_c(world, pos).func_197756_d()) {
            if (!bb.func_186662_g(0.1).func_72318_a(target.func_216347_e().func_178788_d(new Vec3d((Vec3i)pos)))) continue;
            return window.getPickBlock(target, world, pos, player);
        }
        BlockState surrounding = this.getSurroundingBlockState(world, pos);
        return surrounding.getPickBlock(target, world, pos, player);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (!(tileentity instanceof WindowInABlockTileEntity)) {
            return Collections.emptyList();
        }
        WindowInABlockTileEntity te = (WindowInABlockTileEntity)tileentity;
        List drops = te.getPartialBlock().func_215693_a(builder);
        drops.addAll(te.getWindowBlock().func_215693_a(builder));
        return drops;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape1 = this.getSurroundingBlockState(worldIn, pos).func_215700_a(worldIn, pos, context);
        VoxelShape shape2 = this.getWindowBlockState(worldIn, pos).func_215700_a(worldIn, pos, context);
        return VoxelShapes.func_197872_a((VoxelShape)shape1, (VoxelShape)shape2);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public MaterialColor func_180659_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getSurroundingBlockState(worldIn, pos).func_185909_g(worldIn, pos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        this.withTileEntityDo((IBlockReader)worldIn, currentPos, te -> {
            te.setWindowBlock(te.getWindowBlock().func_196956_a(facing, facingState, worldIn, currentPos, facingPos));
            BlockState blockState = te.getPartialBlock().func_196956_a(facing, facingState, worldIn, currentPos, facingPos);
            if (blockState.func_177230_c() instanceof FourWayBlock) {
                for (BooleanProperty side : Arrays.asList(FourWayBlock.field_196411_b, FourWayBlock.field_196409_a, FourWayBlock.field_196413_c, FourWayBlock.field_196414_y)) {
                    blockState = (BlockState)blockState.func_206870_a((IProperty)side, (Comparable)Boolean.valueOf(false));
                }
                te.setPartialBlock(blockState);
            }
            te.requestModelDataUpdate();
        });
        return stateIn;
    }

    private BlockState getSurroundingBlockState(IBlockReader reader, BlockPos pos) {
        try {
            return ((WindowInABlockTileEntity)this.getTileEntity(reader, pos)).getPartialBlock();
        }
        catch (ITE.TileEntityException tileEntityException) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    private BlockState getWindowBlockState(IBlockReader reader, BlockPos pos) {
        try {
            return ((WindowInABlockTileEntity)this.getTileEntity(reader, pos)).getWindowBlock();
        }
        catch (ITE.TileEntityException tileEntityException) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel createModel(IBakedModel original) {
        return new WindowInABlockModel(original);
    }

    @Override
    public Class<WindowInABlockTileEntity> getTileEntityClass() {
        return WindowInABlockTileEntity.class;
    }
}

