/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.partialWindows;

import com.simibubi.create.foundation.block.render.WrappedBakedModel;
import com.simibubi.create.modules.curiosities.partialWindows.WindowInABlockTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class WindowInABlockModel
extends WrappedBakedModel {
    public WindowInABlockModel(IBakedModel template) {
        super(template);
    }

    @Override
    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData data) {
        IModelData modelData;
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockState partialState = (BlockState)data.getData(WindowInABlockTileEntity.PARTIAL_BLOCK);
        BlockState windowState = (BlockState)data.getData(WindowInABlockTileEntity.WINDOW_BLOCK);
        BlockPos position = (BlockPos)data.getData(WindowInABlockTileEntity.POSITION);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (partialState == null || windowState == null) {
            return dispatcher.func_184389_a(Blocks.field_150346_d.func_176223_P()).getQuads(state, side, rand, data);
        }
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        if (partialState.canRenderInLayer(renderLayer) && partialState != null) {
            IBakedModel partialModel = dispatcher.func_184389_a(partialState);
            modelData = partialModel.getModelData((IEnviromentBlockReader)Minecraft.func_71410_x().field_71441_e, position, partialState, (IModelData)EmptyModelData.INSTANCE);
            quads.addAll(partialModel.getQuads(partialState, side, rand, modelData));
        }
        if (windowState.canRenderInLayer(renderLayer) && windowState != null) {
            IBakedModel windowModel = dispatcher.func_184389_a(windowState);
            modelData = windowModel.getModelData((IEnviromentBlockReader)Minecraft.func_71410_x().field_71441_e, position, windowState, (IModelData)EmptyModelData.INSTANCE);
            quads.addAll(dispatcher.func_184389_a(windowState).getQuads(windowState, side, rand, modelData).stream().filter(q -> {
                Direction face = q.func_178210_d();
                if (face != null && world.func_180495_p(position.func_177972_a(face)).func_200017_a(windowState, face)) {
                    return false;
                }
                if (face != null && Block.func_220056_d((BlockState)partialState, (IBlockReader)world, (BlockPos)position, (Direction)face)) {
                    return false;
                }
                this.fightZfighting((BakedQuad)q);
                return true;
            }).collect(Collectors.toList()));
        }
        return quads;
    }

    protected void fightZfighting(BakedQuad q) {
        VertexFormat format = q.getFormat();
        int[] data = q.func_178209_a();
        Vec3i vec = q.func_178210_d().func_176730_m();
        int dirX = vec.func_177958_n();
        int dirY = vec.func_177956_o();
        int dirZ = vec.func_177952_p();
        for (int i = 0; i < 4; ++i) {
            int j = format.func_181719_f() * i;
            float x = Float.intBitsToFloat(data[j + 0]);
            float y = Float.intBitsToFloat(data[j + 1]);
            float z = Float.intBitsToFloat(data[j + 2]);
            double offset = q.func_178210_d().func_176740_k().func_196051_a((double)x, (double)y, (double)z);
            if (!(offset < 9.765625E-4) && !(offset > 0.9990234375)) continue;
            data[j + 0] = Float.floatToIntBits(x - 0.001953125f * (float)dirX);
            data[j + 1] = Float.floatToIntBits(y - 0.001953125f * (float)dirY);
            data[j + 2] = Float.floatToIntBits(z - 0.001953125f * (float)dirZ);
        }
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IModelData data) {
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockState partialState = (BlockState)data.getData(WindowInABlockTileEntity.PARTIAL_BLOCK);
        if (partialState == null) {
            return super.getParticleTexture(data);
        }
        return dispatcher.func_184389_a(partialState).getParticleTexture(data);
    }

    @Override
    public boolean func_177555_b() {
        BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
        return renderLayer == BlockRenderLayer.SOLID;
    }
}

