/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.symmetry;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.modules.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.SymmetryMirror;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SymmetryHandler {
    private static int tickCounter = 0;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b() != AllItems.SYMMETRY_WAND.get()) continue;
            SymmetryWandItem.apply(player.field_70170_p, inv.func_70301_a(i), player, event.getPos(), event.getPlacedBlock());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        if (event.getWorld().func_201670_d()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !AllItems.SYMMETRY_WAND.typeOf(inv.func_70301_a(i))) continue;
            SymmetryWandItem.remove(player.field_70170_p, inv.func_70301_a(i), player, event.getPos());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            SymmetryMirror mirror;
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (stackInSlot == null || !AllItems.SYMMETRY_WAND.typeOf(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
            TessellatorHelper.prepareForDrawing();
            BlockPos pos = new BlockPos(mirror.getPosition());
            float yShift = 0.0f;
            double speed = 0.0625;
            yShift = MathHelper.func_76126_a((float)((float)((double)((float)tickCounter + event.getPartialTicks()) * speed))) / 5.0f;
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            GlStateManager.enableBlend();
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)(yShift + 0.2f), (double)0.0);
            mc.func_175602_ab().renderBlock(mirror.getModel(), pos, (IEnviromentBlockReader)player.field_70170_p, buffer, player.field_70170_p.func_201674_k(), (IModelData)EmptyModelData.INSTANCE);
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.popMatrix();
            TessellatorHelper.cleanUpAfterDrawing();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (mc.field_71441_e == null) {
            return;
        }
        if (mc.func_147113_T()) {
            return;
        }
        if (++tickCounter % 10 == 0) {
            for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
                SymmetryMirror mirror;
                ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
                if (stackInSlot == null || !AllItems.SYMMETRY_WAND.typeOf(stackInSlot) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
                Random r = new Random();
                double offsetX = (r.nextDouble() - 0.5) * 0.3;
                double offsetZ = (r.nextDouble() - 0.5) * 0.3;
                Vec3d pos = mirror.getPosition().func_72441_c(0.5 + offsetX, 0.25, 0.5 + offsetZ);
                Vec3d speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 8.0, 0.0);
                mc.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            }
        }
    }

    public static void drawEffect(BlockPos from, BlockPos to) {
        Vec3d pos;
        double density = 0.8f;
        Vec3d start = new Vec3d((Vec3i)from).func_72441_c(0.5, 0.5, 0.5);
        Vec3d end = new Vec3d((Vec3i)to).func_72441_c(0.5, 0.5, 0.5);
        Vec3d diff = end.func_178788_d(start);
        Vec3d step = diff.func_72432_b().func_186678_a(density);
        int steps = (int)(diff.func_72433_c() / step.func_72433_c());
        Random r = new Random();
        for (int i = 3; i < steps - 1; ++i) {
            pos = start.func_178787_e(step.func_186678_a((double)i));
            Vec3d speed = new Vec3d(0.0, r.nextDouble() * -40.0, 0.0);
            Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 1.0f, 1.0f), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        }
        Vec3d speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.func_178787_e(step.func_186678_a(2.0));
        Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        speed = new Vec3d(0.0, r.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.func_178787_e(step.func_186678_a((double)steps));
        Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197624_q, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
    }
}

