/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.symmetry;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllPackets;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.packet.NbtPacket;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.symmetry.SymmetryWandItem;
import com.simibubi.create.modules.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.SymmetryMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.TriplePlaneMirror;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.fml.network.PacketDistributor;

public class SymmetryWandScreen
extends AbstractSimiScreen {
    private ScrollInput areaType;
    private Label labelType;
    private ScrollInput areaAlign;
    private Label labelAlign;
    private final String mirrorType = Lang.translate("gui.symmetryWand.mirrorType", new Object[0]);
    private final String orientation = Lang.translate("gui.symmetryWand.orientation", new Object[0]);
    private SymmetryMirror currentElement;
    private float animationProgress;
    private ItemStack wand;
    private Hand hand;

    public SymmetryWandScreen(ItemStack wand, Hand hand) {
        this.currentElement = SymmetryWandItem.getMirror(wand);
        if (this.currentElement instanceof EmptyMirror) {
            this.currentElement = new PlaneMirror(Vec3d.field_186680_a);
        }
        this.hand = hand;
        this.wand = wand;
        this.animationProgress = 0.0f;
    }

    public void init() {
        super.init();
        this.setWindowSize(ScreenResources.WAND_SYMMETRY.width + 50, ScreenResources.WAND_SYMMETRY.height + 50);
        this.labelType = new Label(this.guiLeft + 122, this.guiTop + 15, "").colored(-1).withShadow();
        this.labelAlign = new Label(this.guiLeft + 122, this.guiTop + 35, "").colored(-1).withShadow();
        int state = this.currentElement instanceof TriplePlaneMirror ? 2 : (this.currentElement instanceof CrossPlaneMirror ? 1 : 0);
        this.areaType = new SelectionScrollInput(this.guiLeft + 119, this.guiTop + 12, 70, 14).forOptions(SymmetryMirror.getMirrors()).titled(this.mirrorType).writingTo(this.labelType).setState(state);
        this.areaType.calling(position -> {
            switch (position) {
                case 0: {
                    this.currentElement = new PlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 1: {
                    this.currentElement = new CrossPlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 2: {
                    this.currentElement = new TriplePlaneMirror(this.currentElement.getPosition());
                    break;
                }
            }
            this.initAlign(this.currentElement);
        });
        this.widgets.clear();
        this.initAlign(this.currentElement);
        this.widgets.add(this.labelAlign);
        this.widgets.add(this.areaType);
        this.widgets.add(this.labelType);
    }

    private void initAlign(SymmetryMirror element) {
        if (this.areaAlign != null) {
            this.widgets.remove((Object)this.areaAlign);
        }
        this.areaAlign = new SelectionScrollInput(this.guiLeft + 119, this.guiTop + 32, 70, 14).forOptions(element.getAlignToolTips()).titled(this.orientation).writingTo(this.labelAlign).setState(element.getOrientationIndex()).calling(element::setOrientation);
        this.widgets.add(this.areaAlign);
    }

    public void tick() {
        super.tick();
        this.animationProgress += 1.0f;
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        ScreenResources.WAND_SYMMETRY.draw((AbstractGui)this, this.guiLeft, this.guiTop);
        int x = this.guiLeft + 63;
        int y = this.guiTop + 15;
        this.font.func_211126_b(this.mirrorType, (float)(x - 5), (float)y, 5726074);
        this.font.func_211126_b(this.orientation, (float)(x - 5), (float)(y + 20), 5726074);
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.enableBlend();
        this.renderBlock();
        this.renderBlock();
        GlStateManager.pushLightingAttributes();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        GlStateManager.enableBlend();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)((this.width - this.sWidth) / 2 + 250), (double)(this.height / 2 + this.sHeight / 2), (double)100.0);
        GlStateManager.rotatef((float)-30.0f, (float)0.4f, (float)0.0f, (float)-0.2f);
        GlStateManager.rotatef((float)(90.0f + 0.2f * this.animationProgress), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scaled((double)100.0, (double)-100.0, (double)100.0);
        this.itemRenderer.func_180454_a(this.wand, this.itemRenderer.func_204206_b(this.wand));
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
    }

    protected void renderBlock() {
        GlStateManager.pushMatrix();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.translated((double)(this.guiLeft + 15), (double)(this.guiTop - 117), (double)20.0);
        GlStateManager.rotatef((float)-22.5f, (float)0.3f, (float)1.0f, (float)0.0f);
        GlStateManager.scaled((double)32.0, (double)-32.0, (double)32.0);
        this.minecraft.func_175602_ab().renderBlock(this.currentElement.getModel(), new BlockPos(0, -5, 0), (IEnviromentBlockReader)this.minecraft.field_71441_e, buffer, this.minecraft.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.popMatrix();
    }

    public void removed() {
        ItemStack heldItem = this.minecraft.field_71439_g.func_184586_b(this.hand);
        CompoundNBT compound = heldItem.func_77978_p();
        compound.func_218657_a("symmetry", (INBT)this.currentElement.writeToNbt());
        heldItem.func_77982_d(compound);
        AllPackets.channel.send(PacketDistributor.SERVER.noArg(), (Object)new NbtPacket(heldItem, this.hand));
        this.minecraft.field_71439_g.func_184611_a(this.hand, heldItem);
        super.removed();
    }
}

