/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.symmetry.mirror;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.symmetry.block.CrossPlaneSymmetryBlock;
import com.simibubi.create.modules.curiosities.symmetry.mirror.SymmetryMirror;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class CrossPlaneMirror
extends SymmetryMirror {
    public CrossPlaneMirror(Vec3d pos) {
        super(pos);
        this.orientation = Align.Y;
    }

    @Override
    protected void setOrientation() {
        if (this.orientationIndex < 0) {
            this.orientationIndex += Align.values().length;
        }
        if (this.orientationIndex >= Align.values().length) {
            this.orientationIndex -= Align.values().length;
        }
        this.orientation = Align.values()[this.orientationIndex];
    }

    @Override
    public void setOrientation(int index) {
        this.orientation = Align.values()[index];
        this.orientationIndex = index;
    }

    @Override
    public Map<BlockPos, BlockState> process(BlockPos position, BlockState block) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        switch ((Align)this.orientation) {
            case D: {
                result.put(this.flipD1(position), this.flipD1(block));
                result.put(this.flipD2(position), this.flipD2(block));
                result.put(this.flipD1(this.flipD2(position)), this.flipD1(this.flipD2(block)));
                break;
            }
            case Y: {
                result.put(this.flipX(position), this.flipX(block));
                result.put(this.flipZ(position), this.flipZ(block));
                result.put(this.flipX(this.flipZ(position)), this.flipX(this.flipZ(block)));
                break;
            }
        }
        return result;
    }

    @Override
    public String typeName() {
        return "cross_plane";
    }

    @Override
    public BlockState getModel() {
        return (BlockState)AllBlocks.SYMMETRY_CROSSPLANE.get().func_176223_P().func_206870_a(CrossPlaneSymmetryBlock.align, (Comparable)((Object)((Align)this.orientation)));
    }

    @Override
    public List<String> getAlignToolTips() {
        return ImmutableList.of((Object)Lang.translate("orientation.orthogonal", new Object[0]), (Object)Lang.translate("orientation.diagonal", new Object[0]));
    }

    public static enum Align implements IStringSerializable
    {
        Y("y"),
        D("d");

        private final String name;

        private Align(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

