/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.symmetry.mirror;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.symmetry.mirror.CrossPlaneMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.EmptyMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.PlaneMirror;
import com.simibubi.create.modules.curiosities.symmetry.mirror.TriplePlaneMirror;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class SymmetryMirror {
    public static final String EMPTY = "empty";
    public static final String PLANE = "plane";
    public static final String CROSS_PLANE = "cross_plane";
    public static final String TRIPLE_PLANE = "triple_plane";
    protected Vec3d position;
    protected IStringSerializable orientation;
    protected int orientationIndex;
    public boolean enable;
    private static final String $ORIENTATION = "direction";
    private static final String $POSITION = "pos";
    private static final String $TYPE = "type";
    private static final String $ENABLE = "enable";

    public SymmetryMirror(Vec3d pos) {
        this.position = pos;
        this.enable = true;
        this.orientationIndex = 0;
    }

    public static List<String> getMirrors() {
        return ImmutableList.of((Object)Lang.translate("symmetry.mirror.plane", new Object[0]), (Object)Lang.translate("symmetry.mirror.doublePlane", new Object[0]), (Object)Lang.translate("symmetry.mirror.triplePlane", new Object[0]));
    }

    public IStringSerializable getOrientation() {
        return this.orientation;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public int getOrientationIndex() {
        return this.orientationIndex;
    }

    public void rotate(boolean forward) {
        this.orientationIndex += forward ? 1 : -1;
        this.setOrientation();
    }

    public void process(Map<BlockPos, BlockState> blocks) {
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (BlockPos pos : blocks.keySet()) {
            result.putAll(this.process(pos, blocks.get(pos)));
        }
        blocks.putAll(result);
    }

    public abstract Map<BlockPos, BlockState> process(BlockPos var1, BlockState var2);

    protected abstract void setOrientation();

    public abstract void setOrientation(int var1);

    public abstract String typeName();

    public abstract BlockState getModel();

    public CompoundNBT writeToNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a($ORIENTATION, this.orientationIndex);
        ListNBT floatList = new ListNBT();
        floatList.add((Object)new FloatNBT((float)this.position.field_72450_a));
        floatList.add((Object)new FloatNBT((float)this.position.field_72448_b));
        floatList.add((Object)new FloatNBT((float)this.position.field_72449_c));
        nbt.func_218657_a($POSITION, (INBT)floatList);
        nbt.func_74778_a($TYPE, this.typeName());
        nbt.func_74757_a($ENABLE, this.enable);
        return nbt;
    }

    public static SymmetryMirror fromNBT(CompoundNBT nbt) {
        SymmetryMirror element;
        ListNBT floatList = nbt.func_150295_c($POSITION, 5);
        Vec3d pos = new Vec3d((double)floatList.func_150308_e(0), (double)floatList.func_150308_e(1), (double)floatList.func_150308_e(2));
        switch (nbt.func_74779_i($TYPE)) {
            case "plane": {
                element = new PlaneMirror(pos);
                break;
            }
            case "cross_plane": {
                element = new CrossPlaneMirror(pos);
                break;
            }
            case "triple_plane": {
                element = new TriplePlaneMirror(pos);
                break;
            }
            default: {
                element = new EmptyMirror(pos);
            }
        }
        element.setOrientation(nbt.func_74762_e($ORIENTATION));
        element.enable = nbt.func_74767_n($ENABLE);
        return element;
    }

    protected Vec3d getDiff(BlockPos position) {
        return this.position.func_186678_a(-1.0).func_72441_c((double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p());
    }

    protected BlockPos getIDiff(BlockPos position) {
        Vec3d diff = this.getDiff(position);
        return new BlockPos((int)diff.field_72450_a, (int)diff.field_72448_b, (int)diff.field_72449_c);
    }

    protected BlockState flipX(BlockState in) {
        return in.func_185902_a(Mirror.FRONT_BACK);
    }

    protected BlockState flipY(BlockState in) {
        for (IProperty property : in.func_206869_a()) {
            if (property == BlockStateProperties.field_208164_Q) {
                return (BlockState)in.func_177231_a(property);
            }
            if (!(property instanceof DirectionProperty)) continue;
            if (in.func_177229_b(property) == Direction.DOWN) {
                return (BlockState)in.func_206870_a((IProperty)((DirectionProperty)property), (Comparable)Direction.UP);
            }
            if (in.func_177229_b(property) != Direction.UP) continue;
            return (BlockState)in.func_206870_a((IProperty)((DirectionProperty)property), (Comparable)Direction.DOWN);
        }
        return in;
    }

    protected BlockState flipZ(BlockState in) {
        return in.func_185902_a(Mirror.LEFT_RIGHT);
    }

    protected BlockState flipD1(BlockState in) {
        return in.func_185907_a(Rotation.COUNTERCLOCKWISE_90).func_185902_a(Mirror.FRONT_BACK);
    }

    protected BlockState flipD2(BlockState in) {
        return in.func_185907_a(Rotation.COUNTERCLOCKWISE_90).func_185902_a(Mirror.LEFT_RIGHT);
    }

    protected BlockPos flipX(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.func_177958_n() - 2 * diff.func_177958_n(), position.func_177956_o(), position.func_177952_p());
    }

    protected BlockPos flipY(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.func_177958_n(), position.func_177956_o() - 2 * diff.func_177956_o(), position.func_177952_p());
    }

    protected BlockPos flipZ(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p() - 2 * diff.func_177952_p());
    }

    protected BlockPos flipD2(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.func_177958_n() - diff.func_177958_n() + diff.func_177952_p(), position.func_177956_o(), position.func_177952_p() - diff.func_177952_p() + diff.func_177958_n());
    }

    protected BlockPos flipD1(BlockPos position) {
        BlockPos diff = this.getIDiff(position);
        return new BlockPos(position.func_177958_n() - diff.func_177958_n() - diff.func_177952_p(), position.func_177956_o(), position.func_177952_p() - diff.func_177952_p() - diff.func_177958_n());
    }

    public void setPosition(Vec3d pos3d) {
        this.position = pos3d;
    }

    public abstract List<String> getAlignToolTips();
}

