/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.tools;

import com.simibubi.create.foundation.item.AbstractToolItem;
import com.simibubi.create.foundation.item.AllToolTypes;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.curiosities.tools.AllToolTiers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class BlazingToolItem
extends AbstractToolItem {
    static FurnaceTileEntity helperFurnace = new FurnaceTileEntity();

    public BlazingToolItem(float attackDamageIn, float attackSpeedIn, Item.Properties builder, AllToolTypes ... types) {
        super(attackDamageIn, attackSpeedIn, AllToolTiers.BLAZING, builder, types);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return BlazingToolItem.shouldTakeDamage(worldIn, stack) ? super.func_179218_a(stack, worldIn, state, pos, entityLiving) : true;
    }

    public int getBurnTime(ItemStack itemStack) {
        return itemStack.func_77958_k() - itemStack.func_77952_i() + 1;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.func_70015_d(2);
        return BlazingToolItem.shouldTakeDamage(attacker.field_70170_p, stack) ? super.func_77644_a(stack, target, attacker) : true;
    }

    static boolean shouldTakeDamage(World world, ItemStack stack) {
        return world.func_201675_m().func_186058_p() != DimensionType.field_223228_b_;
    }

    @Override
    public boolean modifiesDrops() {
        return true;
    }

    @Override
    public void modifyDrops(Collection<ItemStack> drops, IWorld world, BlockPos pos, ItemStack tool, BlockState state) {
        super.modifyDrops(drops, world, pos, tool, state);
        World worldIn = world.func_201672_e();
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)tool);
        if (state == null) {
            enchantmentLevel = 0;
        }
        List<ItemStack> smeltedStacks = BlazingToolItem.smeltDrops(drops, worldIn, enchantmentLevel);
        drops.addAll(smeltedStacks);
    }

    public static List<ItemStack> smeltDrops(Collection<ItemStack> drops, World worldIn, int enchantmentLevel) {
        helperFurnace.func_145834_a(worldIn);
        RecipeManager recipeManager = worldIn.func_199532_z();
        ArrayList<ItemStack> smeltedStacks = new ArrayList<ItemStack>();
        Iterator<ItemStack> dropper = drops.iterator();
        while (dropper.hasNext()) {
            ItemStack stack = dropper.next();
            helperFurnace.func_70299_a(0, stack);
            Optional smeltingRecipe = recipeManager.func_215371_a(IRecipeType.field_222150_b, (IInventory)helperFurnace, worldIn);
            if (!smeltingRecipe.isPresent()) continue;
            dropper.remove();
            ItemStack out = ((FurnaceRecipe)smeltingRecipe.get()).func_77571_b().func_77946_l();
            float modifier = 1.0f;
            if (stack.func_77973_b() instanceof BlockItem && !(out.func_77973_b() instanceof BlockItem)) {
                modifier += worldIn.func_201674_k().nextFloat() * (float)enchantmentLevel;
            }
            out.func_190920_e((int)((float)out.func_190916_E() * modifier + 0.4f));
            smeltedStacks.addAll(ItemHelper.multipliedOutput(stack, out));
        }
        return smeltedStacks;
    }

    @Override
    public void spawnParticles(IWorld world, BlockPos pos, ItemStack tool, BlockState state) {
        if (!this.canHarvestBlock(tool, state)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            Vec3d flamePos = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)pos), world.func_201674_k(), 0.45f);
            Vec3d smokePos = VecHelper.offsetRandomly(VecHelper.getCenterOf((Vec3i)pos), world.func_201674_k(), 0.45f);
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, flamePos.func_82615_a(), flamePos.func_82617_b(), flamePos.func_82616_c(), 0.0, (double)0.01f, 0.0);
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, smokePos.func_82615_a(), smokePos.func_82617_b(), smokePos.func_82616_c(), 0.0, (double)0.1f, 0.0);
        }
    }
}

