/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.tools;

import com.simibubi.create.foundation.block.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.IHaveCustomItemModel;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.curiosities.tools.SandPaperItemRenderer;
import com.simibubi.create.modules.curiosities.tools.SandPaperPolishingRecipe;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

public class SandPaperItem
extends Item
implements IHaveCustomItemModel {
    public SandPaperItem(Item.Properties properties) {
        super(properties);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.EAT;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult FAIL = new ActionResult(ActionResultType.FAIL, (Object)itemstack);
        if (itemstack.func_196082_o().func_74764_b("Polishing")) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.PASS, (Object)itemstack);
        }
        Hand otherHand = handIn == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND;
        ItemStack itemInOtherHand = playerIn.func_184586_b(otherHand);
        if (SandPaperPolishingRecipe.canPolish(worldIn, itemInOtherHand)) {
            ItemStack item = itemInOtherHand.func_77946_l();
            ItemStack toPolish = item.func_77979_a(1);
            playerIn.func_184598_c(handIn);
            itemstack.func_196082_o().func_218657_a("Polishing", (INBT)toPolish.serializeNBT());
            playerIn.func_184611_a(otherHand, item);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = SandPaperItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (!(raytraceresult instanceof BlockRayTraceResult)) {
            return FAIL;
        }
        BlockRayTraceResult ray = (BlockRayTraceResult)raytraceresult;
        Vec3d hitVec = ray.func_216347_e();
        if (hitVec == null) {
            return FAIL;
        }
        AxisAlignedBB bb = new AxisAlignedBB(hitVec, hitVec).func_186662_g(1.0);
        ItemEntity pickUp = null;
        for (ItemEntity itemEntity : worldIn.func_217357_a(ItemEntity.class, bb)) {
            ItemStack stack;
            if (itemEntity.func_213303_ch().func_72438_d(playerIn.func_213303_ch()) > 3.0 || !SandPaperPolishingRecipe.canPolish(worldIn, stack = itemEntity.func_92059_d())) continue;
            pickUp = itemEntity;
            break;
        }
        if (pickUp == null) {
            return FAIL;
        }
        ItemStack item = pickUp.func_92059_d().func_77946_l();
        ItemStack toPolish = item.func_77979_a(1);
        playerIn.func_184598_c(handIn);
        if (!worldIn.field_72995_K) {
            itemstack.func_196082_o().func_218657_a("Polishing", (INBT)toPolish.serializeNBT());
            if (item.func_190926_b()) {
                pickUp.func_70106_y();
            } else {
                pickUp.func_92058_a(item);
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 1;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity entityLiving) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Polishing")) {
            ItemStack toPolish = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Polishing"));
            ItemStack polished = SandPaperPolishingRecipe.applyPolish(worldIn, entityLiving.func_213303_ch(), toPolish, stack);
            if (worldIn.field_72995_K) {
                SandPaperItem.spawnParticles(entityLiving.func_174824_e(1.0f).func_178787_e(entityLiving.func_70040_Z().func_186678_a(0.5)), toPolish, worldIn);
                return stack;
            }
            if (!polished.func_190926_b()) {
                if (player instanceof FakePlayer) {
                    player.func_146097_a(polished, false, false);
                } else {
                    player.field_71071_by.func_191975_a(worldIn, polished);
                }
            }
            tag.func_82580_o("Polishing");
            stack.func_222118_a(1, entityLiving, p -> p.func_213334_d(p.func_184600_cs()));
        }
        return stack;
    }

    public static void spawnParticles(Vec3d location, ItemStack polishedStack, World world) {
        for (int i = 0; i < 20; ++i) {
            Vec3d motion = VecHelper.offsetRandomly(Vec3d.field_186680_a, world.field_73012_v, 0.125f);
            world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, polishedStack), location.field_72450_a, location.field_72448_b, location.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Polishing")) {
            ItemStack toPolish = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Polishing"));
            player.field_71071_by.func_191975_a(worldIn, toPolish);
            tag.func_82580_o("Polishing");
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return 8;
    }

    public int func_77619_b() {
        return 5;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CustomRenderedItemModel createModel(IBakedModel original) {
        return new SandPaperItemRenderer.SandPaperModel(original);
    }
}

