/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.tools;

import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.item.AbstractToolItem;
import com.simibubi.create.modules.curiosities.tools.AllToolTiers;
import com.simibubi.create.modules.curiosities.tools.BlazingToolItem;
import com.simibubi.create.modules.curiosities.tools.RoseQuartzToolItem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ToolEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void toolsCanModifyBlockDrops(BlockEvent.BreakEvent event) {
        boolean onServer;
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack held = player.func_184614_ca();
        if (player.func_184812_l_()) {
            return;
        }
        if (!(held.func_77973_b() instanceof AbstractToolItem)) {
            return;
        }
        AbstractToolItem tool = (AbstractToolItem)held.func_77973_b();
        if (!tool.modifiesDrops()) {
            return;
        }
        BlockState state = event.getState();
        if (!tool.canHarvestBlock(held, state) && !state.func_185904_a().func_76229_l()) {
            return;
        }
        IWorld world = event.getWorld();
        BlockPos pos = event.getPos();
        boolean bl = onServer = !world.func_201670_d();
        if (!onServer) {
            tool.spawnParticles(world, pos, held, state);
            return;
        }
        World actualWorld = world.func_201672_e();
        if (!(actualWorld instanceof ServerWorld)) {
            return;
        }
        List drops = state.func_215693_a(new LootContext.Builder((ServerWorld)actualWorld).func_216023_a(actualWorld.func_201674_k()).func_216015_a(LootParameters.field_216286_f, (Object)pos).func_216015_a(LootParameters.field_216289_i, (Object)held).func_216015_a(LootParameters.field_216281_a, (Object)player).func_216021_b(LootParameters.field_216288_h, (Object)world.func_175625_s(pos)));
        tool.modifyDrops(drops, world, pos, held, state);
        tool.func_179218_a(held, actualWorld, state, pos, (LivingEntity)player);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        for (ItemStack dropped : drops) {
            Block.func_180635_a((World)actualWorld, (BlockPos)pos, (ItemStack)dropped);
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new AbstractToolItem.HarvestPacket(state, held, pos, false));
        AllPackets.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new AbstractToolItem.HarvestPacket(state, held, pos, true));
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public static void holdingRoseQuartzToolIncreasesRange(LivingEvent.LivingUpdateEvent event) {
        boolean holdingRoseQuartz;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        ItemStack heldItemMainhand = player.func_184614_ca();
        String marker = "create_roseQuartzRange";
        CompoundNBT persistentData = player.getPersistentData();
        Item item = heldItemMainhand.func_77973_b();
        boolean bl = holdingRoseQuartz = item instanceof TieredItem && ((TieredItem)item).func_200891_e() == AllToolTiers.ROSE_QUARTZ;
        if (!holdingRoseQuartz) {
            if (persistentData.func_74764_b(marker)) {
                player.func_110140_aT().func_111148_a(RoseQuartzToolItem.rangeModifier);
                persistentData.func_82580_o(marker);
            }
            return;
        }
        if (!persistentData.func_74764_b(marker)) {
            player.func_110140_aT().func_111147_b(RoseQuartzToolItem.rangeModifier);
            persistentData.func_74757_a(marker, true);
        }
    }

    @SubscribeEvent
    public static void toolsMayModifyEntityLoot(LivingDropsEvent event) {
        if (!(event.getSource() instanceof EntityDamageSource)) {
            return;
        }
        EntityDamageSource source = (EntityDamageSource)event.getSource();
        Entity target = event.getEntity();
        Entity trueSource = source.func_76346_g();
        World world = target.func_130014_f_();
        if (trueSource != null && trueSource instanceof PlayerEntity) {
            IItemTier tier;
            PlayerEntity player = (PlayerEntity)trueSource;
            ItemStack heldItemMainhand = player.func_184614_ca();
            Item item = heldItemMainhand.func_77973_b();
            IItemTier iItemTier = tier = item instanceof TieredItem ? ((TieredItem)item).func_200891_e() : null;
            if (tier == AllToolTiers.SHADOW_STEEL) {
                event.setCanceled(true);
            }
            if (tier == AllToolTiers.BLAZING) {
                List<ItemStack> drops = event.getDrops().stream().map(entity -> {
                    ItemStack stack = entity.func_92059_d();
                    entity.func_70106_y();
                    return stack;
                }).collect(Collectors.toList());
                drops = BlazingToolItem.smeltDrops(drops, world, 0);
                event.getDrops().clear();
                drops.stream().map(stack -> {
                    ItemEntity entity = new ItemEntity(world, target.field_70165_t, target.field_70163_u, target.field_70161_v, stack);
                    world.func_217376_c((Entity)entity);
                    return entity;
                }).forEach(event.getDrops()::add);
            }
        }
    }

    @SubscribeEvent
    public static void shadowSteelToolsDropMoreXPonKill(LivingExperienceDropEvent event) {
        IItemTier tier;
        PlayerEntity attackingPlayer = event.getAttackingPlayer();
        if (attackingPlayer == null) {
            return;
        }
        ItemStack heldItemMainhand = attackingPlayer.func_184614_ca();
        Item item = heldItemMainhand.func_77973_b();
        IItemTier iItemTier = tier = item instanceof TieredItem ? ((TieredItem)item).func_200891_e() : null;
        if (tier == AllToolTiers.SHADOW_STEEL) {
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)heldItemMainhand);
            float modifier = 1.0f + event.getEntity().field_70170_p.func_201674_k().nextFloat() * (float)level;
            event.setDroppedExperience((int)((float)event.getDroppedExperience() * modifier + 0.4f));
        }
    }
}

