/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.curiosities.zapper.ZapperItem;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ZapperRenderHandler {
    public static List<LaserBeam> cachedBeams;
    public static float leftHandAnimation;
    public static float rightHandAnimation;
    public static float lastLeftHandAnimation;
    public static float lastRightHandAnimation;
    private static boolean dontReequipLeft;
    private static boolean dontReequipRight;

    public static Vec3d getExactBarrelPos(boolean mainHand) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float yaw = (float)((double)(player.func_195046_g(partialTicks) / -180.0f) * Math.PI);
        float pitch = (float)((double)(player.func_195050_f(partialTicks) / -180.0f) * Math.PI);
        boolean rightHand = mainHand == (player.func_184591_cq() == HandSide.RIGHT);
        float zOffset = ((float)Minecraft.func_71410_x().field_71474_y.field_74334_X - 70.0f) / -100.0f;
        Vec3d barrelPosNoTransform = new Vec3d(rightHand ? (double)-0.35f : (double)0.35f, (double)-0.115f, (double)(0.75f + zOffset));
        Vec3d barrelPos = player.func_174824_e(partialTicks).func_178787_e(barrelPosNoTransform.func_178789_a(pitch).func_178785_b(yaw));
        return barrelPos;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (cachedBeams == null) {
            cachedBeams = new LinkedList<LaserBeam>();
        }
        if ((world = Minecraft.func_71410_x().field_71441_e) == null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        cachedBeams.removeIf(b -> b.itensity < 0.1f);
        cachedBeams.forEach(b -> b.itensity *= 0.4f);
        lastLeftHandAnimation = leftHandAnimation;
        lastRightHandAnimation = rightHandAnimation;
        leftHandAnimation *= 0.8f;
        rightHandAnimation *= 0.8f;
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        if (cachedBeams == null || cachedBeams.isEmpty()) {
            return;
        }
        cachedBeams.forEach(beam -> {
            TessellatorHelper.prepareForDrawing();
            GlStateManager.disableTexture();
            GlStateManager.lineWidth((float)(beam.itensity * 40.0f));
            BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
            bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            bufferBuilder.func_181662_b(beam.getStart().field_72450_a, beam.getStart().field_72448_b, beam.getStart().field_72449_c).func_181675_d();
            bufferBuilder.func_181662_b(beam.end.field_72450_a, beam.end.field_72448_b, beam.end.field_72449_c).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.lineWidth((float)1.0f);
            GlStateManager.enableTexture();
            TessellatorHelper.cleanUpAfterDrawing();
        });
    }

    public static void shoot(Hand hand) {
        ClientPlayerEntity player;
        boolean rightHand = hand == Hand.MAIN_HAND ^ (player = Minecraft.func_71410_x().field_71439_g).func_184591_cq() == HandSide.LEFT;
        if (rightHand) {
            rightHandAnimation = 0.2f;
            dontReequipRight = false;
        } else {
            leftHandAnimation = 0.2f;
            dontReequipLeft = false;
        }
        ZapperRenderHandler.playSound(hand, player.func_180425_c());
    }

    public static void playSound(Hand hand, BlockPos position) {
        float pitch = hand == Hand.MAIN_HAND ? 2.0f : 0.9f;
        Minecraft.func_71410_x().field_71441_e.func_184156_a(position, AllSoundEvents.BLOCKZAPPER_PLACE.get(), SoundCategory.BLOCKS, 0.8f, pitch, false);
    }

    public static void addBeam(LaserBeam beam) {
        Random r = new Random();
        double x = beam.end.field_72450_a;
        double y = beam.end.field_72448_b;
        double z = beam.end.field_72449_c;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Supplier<Double> randomSpeed = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        Supplier<Double> randomOffset = () -> (r.nextDouble() - 0.5) * (double)0.2f;
        for (int i = 0; i < 10; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, x, y, z, randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue(), randomSpeed.get().doubleValue());
            world.func_195594_a((IParticleData)ParticleTypes.field_197629_v, x + randomOffset.get(), y + randomOffset.get(), z + randomOffset.get(), 0.0, 0.0, 0.0);
        }
        cachedBeams.add(beam);
    }

    @SubscribeEvent
    public static void onRenderPlayerHand(RenderSpecificHandEvent event) {
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.func_77973_b() instanceof ZapperItem)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean rightHand = event.getHand() == Hand.MAIN_HAND ^ mc.field_71439_g.func_184591_cq() == HandSide.LEFT;
        GlStateManager.pushMatrix();
        float recoil = rightHand ? MathHelper.func_219799_g((float)event.getPartialTicks(), (float)lastRightHandAnimation, (float)rightHandAnimation) : MathHelper.func_219799_g((float)event.getPartialTicks(), (float)lastLeftHandAnimation, (float)leftHandAnimation);
        float equipProgress = event.getEquipProgress();
        if (rightHand && (rightHandAnimation > 0.01f || dontReequipRight)) {
            equipProgress = 0.0f;
        }
        if (!rightHand && (leftHandAnimation > 0.01f || dontReequipLeft)) {
            equipProgress = 0.0f;
        }
        float f = rightHand ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)event.getSwingProgress());
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(event.getSwingProgress() * (float)Math.PI));
        GlStateManager.translatef((float)(f * (f2 + 0.64000005f - 0.1f)), (float)(f3 + -0.4f + equipProgress * -0.6f), (float)(f4 + -0.71999997f + 0.3f + recoil));
        GlStateManager.rotatef((float)(f * 75.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(event.getSwingProgress() * event.getSwingProgress() * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.rotatef((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        ClientPlayerEntity abstractclientplayerentity = mc.field_71439_g;
        mc.func_110434_K().func_110577_a(abstractclientplayerentity.func_110306_p());
        GlStateManager.translatef((float)(f * -1.0f), (float)3.6f, (float)3.5f);
        GlStateManager.rotatef((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.rotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * 40.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        PlayerRenderer playerrenderer = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)abstractclientplayerentity);
        GlStateManager.disableCull();
        if (rightHand) {
            playerrenderer.func_177138_b((AbstractClientPlayerEntity)abstractclientplayerentity);
        } else {
            playerrenderer.func_177139_c((AbstractClientPlayerEntity)abstractclientplayerentity);
        }
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(f * (f2 + 0.64000005f - 0.1f)), (float)(f3 + -0.4f + equipProgress * -0.6f), (float)(f4 + -0.71999997f - 0.1f + recoil));
        GlStateManager.rotatef((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)(f * -0.1f), (float)0.1f, (float)-0.4f);
        GlStateManager.rotatef((float)(f * 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        FirstPersonRenderer firstPersonRenderer = mc.func_175597_ag();
        firstPersonRenderer.func_187462_a((LivingEntity)mc.field_71439_g, heldItem, rightHand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !rightHand);
        GlStateManager.popMatrix();
        event.setCanceled(true);
    }

    public static void dontAnimateItem(Hand hand) {
        boolean rightHand = hand == Hand.MAIN_HAND ^ Minecraft.func_71410_x().field_71439_g.func_184591_cq() == HandSide.LEFT;
        dontReequipRight |= rightHand;
        dontReequipLeft |= !rightHand;
    }

    public static class LaserBeam {
        float itensity;
        Vec3d start;
        Vec3d end;
        boolean follow;
        boolean mainHand;

        public LaserBeam(Vec3d start, Vec3d end) {
            this.start = start;
            this.end = end;
            this.itensity = 1.0f;
        }

        public LaserBeam followPlayer(boolean follow, boolean mainHand) {
            this.follow = follow;
            this.mainHand = mainHand;
            return this;
        }

        public Vec3d getStart() {
            if (this.follow) {
                return ZapperRenderHandler.getExactBarrelPos(this.mainHand);
            }
            return this.start;
        }
    }
}

