/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllPackets;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.packet.NbtPacket;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.zapper.PlacementPatterns;
import java.util.Vector;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ZapperScreen
extends AbstractSimiScreen {
    protected ItemStack zapper;
    protected boolean offhand;
    protected float animationProgress;
    protected ScreenResources background;
    protected final String patternSection = Lang.translate("gui.blockzapper.patternSection", new Object[0]);
    protected String title;
    protected Vector<IconButton> patternButtons;
    protected int brightColor;
    protected int fontColor;

    public ZapperScreen(ScreenResources background, ItemStack zapper, boolean offhand) {
        this.background = background;
        this.zapper = zapper;
        this.offhand = offhand;
        this.title = "";
        this.brightColor = 0xCCDDFF;
        this.fontColor = 5726074;
    }

    protected void init() {
        this.animationProgress = 0.0f;
        this.setWindowSize(this.background.width + 40, this.background.height);
        super.init();
        this.widgets.clear();
        int i = this.guiLeft - 20;
        int j = this.guiTop;
        CompoundNBT nbt = this.zapper.func_196082_o();
        this.patternButtons = new Vector(6);
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                this.patternButtons.add(new IconButton(i + 147 + col * 18, j + 23 + row * 18, pattern.icon));
                this.patternButtons.get(id).setToolTip(Lang.translate("gui.blockzapper.pattern." + pattern.translationKey, new Object[0]));
            }
        }
        if (nbt.func_74764_b("Pattern")) {
            this.patternButtons.get((int)PlacementPatterns.valueOf((String)nbt.func_74779_i((String)"Pattern")).ordinal()).active = false;
        }
        this.widgets.addAll(this.patternButtons);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int i = this.guiLeft - 20;
        int j = this.guiTop;
        this.background.draw((AbstractGui)this, i, j);
        this.drawOnBackground(i, j);
        this.minecraft.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        GlStateManager.enableBlend();
        this.renderBlock();
        this.renderZapper();
    }

    protected void drawOnBackground(int i, int j) {
        this.font.func_175063_a(this.title, (float)(i + 8), (float)(j + 10), this.brightColor);
        this.font.func_211126_b(this.patternSection, (float)(i + 148), (float)(j + 11), this.fontColor);
    }

    public void tick() {
        super.tick();
        this.animationProgress += 5.0f;
    }

    public void onClose() {
        CompoundNBT nbt = this.zapper.func_77978_p();
        this.writeAdditionalOptions(nbt);
        AllPackets.channel.sendToServer((Object)new NbtPacket(this.zapper, this.offhand ? Hand.OFF_HAND : Hand.MAIN_HAND));
        super.onClose();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        CompoundNBT nbt = this.zapper.func_77978_p();
        for (IconButton patternButton : this.patternButtons) {
            if (!patternButton.isHovered()) continue;
            this.patternButtons.forEach(b -> {
                b.active = true;
            });
            patternButton.active = false;
            patternButton.playDownSound(Minecraft.func_71410_x().func_147118_V());
            nbt.func_74778_a("Pattern", PlacementPatterns.values()[this.patternButtons.indexOf((Object)patternButton)].name());
        }
        return super.mouseClicked(x, y, button);
    }

    protected void renderZapper() {
        GlStateManager.pushLightingAttributes();
        GlStateManager.pushMatrix();
        RenderHelper.func_74519_b();
        GlStateManager.enableBlend();
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)((this.width - this.sWidth) / 2 + 260), (double)(this.height / 2 - this.sHeight / 4), (double)100.0);
        GlStateManager.rotatef((float)(90.0f + 0.2f * this.animationProgress), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)-40.0f, (float)0.8f, (float)0.0f, (float)-0.0f);
        GlStateManager.scaled((double)100.0, (double)-100.0, (double)100.0);
        IBakedModel model = this.itemRenderer.func_204206_b(this.zapper);
        model.handlePerspective(ItemCameraTransforms.TransformType.FIXED);
        this.itemRenderer.func_180454_a(this.zapper, model);
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
    }

    protected void renderBlock() {
        GlStateManager.pushMatrix();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.translated((double)((float)this.guiLeft + 1.7f), (double)(this.guiTop - 49), (double)120.0);
        GlStateManager.rotatef((float)-30.0f, (float)0.5f, (float)0.9f, (float)-0.1f);
        GlStateManager.scaled((double)20.0, (double)-20.0, (double)20.0);
        BlockState state = Blocks.field_150350_a.func_176223_P();
        if (this.zapper.func_77942_o() && this.zapper.func_77978_p().func_74764_b("BlockUsed")) {
            state = NBTUtil.func_190008_d((CompoundNBT)this.zapper.func_77978_p().func_74775_l("BlockUsed"));
        }
        this.minecraft.func_175602_ab().renderBlock(state, new BlockPos(0, -5, 0), (IEnviromentBlockReader)this.minecraft.field_71441_e, buffer, this.minecraft.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.popMatrix();
    }

    protected void writeAdditionalOptions(CompoundNBT nbt) {
    }
}

