/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper.blockzapper;

import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.zapper.ZapperScreen;
import com.simibubi.create.modules.curiosities.zapper.blockzapper.BlockzapperItem;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TextFormatting;

public class BlockzapperScreen
extends ZapperScreen {
    private final String needsUpgradedAmplifier = Lang.translate("gui.blockzapper.needsUpgradedAmplifier", new Object[0]);
    private IconButton replaceModeButton;
    private Indicator replaceModeIndicator;
    private IconButton spreadDiagonallyButton;
    private Indicator spreadDiagonallyIndicator;
    private IconButton spreadMaterialButton;
    private Indicator spreadMaterialIndicator;
    private ScrollInput spreadRangeInput;
    private Label spreadRangeLabel;

    public BlockzapperScreen(ItemStack zapper, boolean offhand) {
        super(ScreenResources.BLOCKZAPPER, zapper, offhand);
        this.title = Lang.translate("gui.blockzapper.title", new Object[0]);
    }

    @Override
    protected void init() {
        super.init();
        int i = this.guiLeft - 20;
        int j = this.guiTop;
        CompoundNBT nbt = this.zapper.func_196082_o();
        this.replaceModeIndicator = new Indicator(i + 51, j + 36, "");
        this.replaceModeButton = new IconButton(i + 51, j + 41, ScreenResources.I_REPLACE_SOLID);
        if (nbt.func_74764_b("Replace") && nbt.func_74767_n("Replace")) {
            this.replaceModeIndicator.state = Indicator.State.ON;
        }
        this.replaceModeButton.setToolTip(Lang.translate("gui.blockzapper.replaceMode", new Object[0]));
        this.spreadDiagonallyIndicator = new Indicator(i + 74, j + 36, "");
        this.spreadDiagonallyButton = new IconButton(i + 74, j + 41, ScreenResources.I_FOLLOW_DIAGONAL);
        if (nbt.func_74764_b("SearchDiagonal") && nbt.func_74767_n("SearchDiagonal")) {
            this.spreadDiagonallyIndicator.state = Indicator.State.ON;
        }
        this.spreadDiagonallyButton.setToolTip(Lang.translate("gui.blockzapper.searchDiagonal", new Object[0]));
        this.spreadMaterialIndicator = new Indicator(i + 92, j + 36, "");
        this.spreadMaterialButton = new IconButton(i + 92, j + 41, ScreenResources.I_FOLLOW_MATERIAL);
        if (nbt.func_74764_b("SearchFuzzy") && nbt.func_74767_n("SearchFuzzy")) {
            this.spreadMaterialIndicator.state = Indicator.State.ON;
        }
        this.spreadMaterialButton.setToolTip(Lang.translate("gui.blockzapper.searchFuzzy", new Object[0]));
        this.spreadRangeLabel = new Label(i + 119, j + 46, "").withShadow().withSuffix("m");
        this.spreadRangeInput = new ScrollInput(i + 115, j + 43, 22, 14).withRange(1, BlockzapperItem.getMaxAoe(this.zapper)).setState(1).titled(Lang.translate("gui.blockzapper.range", new Object[0])).writingTo(this.spreadRangeLabel);
        if (nbt.func_74764_b("SearchDistance")) {
            this.spreadRangeInput.setState(nbt.func_74762_e("SearchDistance"));
        }
        if (BlockzapperItem.getMaxAoe(this.zapper) == 2) {
            this.spreadRangeInput.getToolTip().add(1, TextFormatting.RED + this.needsUpgradedAmplifier);
        }
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.replaceModeButton, this.replaceModeIndicator, this.spreadDiagonallyButton, this.spreadDiagonallyIndicator, this.spreadMaterialButton, this.spreadMaterialIndicator, this.spreadRangeLabel, this.spreadRangeInput});
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        boolean mode;
        CompoundNBT nbt = this.zapper.func_77978_p();
        if (this.replaceModeButton.isHovered()) {
            mode = nbt.func_74764_b("Replace") && nbt.func_74767_n("Replace");
            mode = !mode;
            this.replaceModeIndicator.state = mode ? Indicator.State.ON : Indicator.State.OFF;
            nbt.func_74757_a("Replace", mode);
        }
        if (this.spreadDiagonallyButton.isHovered()) {
            mode = nbt.func_74764_b("SearchDiagonal") && nbt.func_74767_n("SearchDiagonal");
            mode = !mode;
            this.spreadDiagonallyIndicator.state = mode ? Indicator.State.ON : Indicator.State.OFF;
            nbt.func_74757_a("SearchDiagonal", mode);
        }
        if (this.spreadMaterialButton.isHovered()) {
            mode = nbt.func_74764_b("SearchFuzzy") && nbt.func_74767_n("SearchFuzzy");
            mode = !mode;
            this.spreadMaterialIndicator.state = mode ? Indicator.State.ON : Indicator.State.OFF;
            nbt.func_74757_a("SearchFuzzy", mode);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    protected void writeAdditionalOptions(CompoundNBT nbt) {
        nbt.func_74768_a("SearchDistance", this.spreadRangeInput.getState());
    }
}

