/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper.terrainzapper;

import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.PlacementOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.apache.commons.lang3.tuple.Pair;

public class CylinderBrush
extends Brush {
    public static final int MAX_RADIUS = 6;
    public static final int MAX_HEIGHT = 8;
    private Map<Pair<Integer, Integer>, Pair<List<BlockPos>, VoxelShape>> cachedBrushes = new HashMap<Pair<Integer, Integer>, Pair<List<BlockPos>, VoxelShape>>();

    public CylinderBrush() {
        super(2);
        VoxelShape fullCube = Block.func_208617_a((double)-0.5, (double)-0.5, (double)-0.5, (double)16.5, (double)16.5, (double)16.5);
        for (int i = 0; i <= 6; ++i) {
            int radius = i;
            VoxelShape shape = VoxelShapes.func_197880_a();
            List positions = BlockPos.func_218281_b((BlockPos)BlockPos.field_177992_a.func_177982_a(-i - 1, 0, -i - 1), (BlockPos)BlockPos.field_177992_a.func_177982_a(i + 1, 0, i + 1)).map(BlockPos::new).filter(p -> VecHelper.getCenterOf((Vec3i)p).func_72438_d(VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a)) < (double)((float)radius + 0.42f)).collect(Collectors.toList());
            for (BlockPos p2 : positions) {
                shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)fullCube.func_197751_a((double)p2.func_177958_n(), (double)p2.func_177956_o(), (double)p2.func_177952_p()));
            }
            for (int h = 0; h <= 8; ++h) {
                ArrayList<BlockPos> stackedPositions = new ArrayList<BlockPos>();
                VoxelShape stackedShape = shape.func_197753_c();
                for (int layer = 0; layer < h; ++layer) {
                    int yOffset = layer - h / 2;
                    stackedShape = VoxelShapes.func_197872_a((VoxelShape)stackedShape, (VoxelShape)shape.func_197751_a(0.0, (double)yOffset, 0.0));
                    for (BlockPos p3 : positions) {
                        stackedPositions.add(p3.func_177981_b(yOffset));
                    }
                }
                this.cachedBrushes.put((Pair<Integer, Integer>)Pair.of((Object)i, (Object)h), (Pair<List<BlockPos>, VoxelShape>)Pair.of(stackedPositions, (Object)stackedShape.func_197753_c()));
            }
        }
    }

    @Override
    public BlockPos getOffset(Vec3d ray, Direction face, PlacementOptions option) {
        boolean negative;
        if (option == PlacementOptions.Merged) {
            return BlockPos.field_177992_a;
        }
        int offset = option == PlacementOptions.Attached ? 0 : -1;
        boolean bl = negative = face.func_176743_c() == Direction.AxisDirection.NEGATIVE;
        int yOffset = option == PlacementOptions.Attached ? (negative ? 1 : 2) : (negative ? 0 : -1);
        int r = this.param0 + 1 + offset;
        int y = (this.param1 + (this.param1 == 0 ? 0 : yOffset)) / 2;
        return BlockPos.field_177992_a.func_177967_a(face, (face.func_176740_k().func_200128_b() ? y : r) * (option == PlacementOptions.Attached ? 1 : -1));
    }

    @Override
    int getMax(int paramIndex) {
        return paramIndex == 0 ? 6 : 8;
    }

    @Override
    int getMin(int paramIndex) {
        return paramIndex == 0 ? 0 : 1;
    }

    @Override
    String getParamLabel(int paramIndex) {
        return paramIndex == 0 ? Lang.translate("generic.radius", new Object[0]) : super.getParamLabel(paramIndex);
    }

    @Override
    VoxelShape getSelectionBox() {
        return (VoxelShape)this.getEntry(this.param0, this.param1).getRight();
    }

    @Override
    public List<BlockPos> getIncludedPositions() {
        return (List)this.getEntry(this.param0, this.param1).getLeft();
    }

    protected Pair<List<BlockPos>, VoxelShape> getEntry(int radius, int height) {
        return this.cachedBrushes.get(Pair.of((Object)radius, (Object)height));
    }
}

