/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper.terrainzapper;

import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.FlattenTool;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum TerrainTools {
    Fill(ScreenResources.I_FILL),
    Place(ScreenResources.I_PLACE),
    Replace(ScreenResources.I_REPLACE),
    Clear(ScreenResources.I_CLEAR),
    Overlay(ScreenResources.I_OVERLAY),
    Flatten(ScreenResources.I_FLATTEN);

    public String translationKey = Lang.asId(this.name());
    public ScreenResources icon;

    private TerrainTools(ScreenResources icon) {
        this.icon = icon;
    }

    public boolean requiresSelectedBlock() {
        return this != Clear && this != Flatten;
    }

    public void run(World world, List<BlockPos> targetPositions, Direction facing, @Nullable BlockState paintedState) {
        switch (this) {
            case Clear: {
                targetPositions.forEach(p -> world.func_175656_a(p, Blocks.field_150350_a.func_176223_P()));
                break;
            }
            case Fill: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.func_180495_p(p);
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                });
                break;
            }
            case Flatten: {
                FlattenTool.apply(world, targetPositions, facing);
                break;
            }
            case Overlay: {
                targetPositions.forEach(p -> {
                    BlockState toOverlay = world.func_180495_p(p);
                    if (TerrainTools.isReplaceable(toOverlay)) {
                        return;
                    }
                    if (toOverlay == paintedState) {
                        return;
                    }
                    BlockState toReplace = world.func_180495_p(p = p.func_177984_a());
                    if (!TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                });
                break;
            }
            case Place: {
                targetPositions.forEach(p -> world.func_175656_a(p, paintedState));
                break;
            }
            case Replace: {
                targetPositions.forEach(p -> {
                    BlockState toReplace = world.func_180495_p(p);
                    if (TerrainTools.isReplaceable(toReplace)) {
                        return;
                    }
                    world.func_175656_a(p, paintedState);
                });
            }
        }
    }

    public static boolean isReplaceable(BlockState toReplace) {
        return toReplace.func_185904_a().func_76222_j();
    }
}

