/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper.terrainzapper;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.TessellatorHelper;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainBrushes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShape;

public class TerrainZapperRenderHandler {
    private static VoxelShape renderedShape;
    private static BlockPos renderedPosition;

    public static void tick() {
        CompoundNBT tag;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldMain = player.func_184614_ca();
        ItemStack heldOff = player.func_184592_cb();
        boolean zapperInMain = AllItems.TERRAIN_ZAPPER.typeOf(heldMain);
        boolean zapperInOff = AllItems.TERRAIN_ZAPPER.typeOf(heldOff);
        if (zapperInMain && !(tag = heldMain.func_196082_o()).func_74764_b("_Swap")) {
            TerrainZapperRenderHandler.createBrushOutline(tag, player, heldMain);
            return;
        }
        if (zapperInOff) {
            tag = heldOff.func_196082_o();
            TerrainZapperRenderHandler.createBrushOutline(tag, player, heldOff);
            return;
        }
        renderedPosition = null;
    }

    public static void createBrushOutline(CompoundNBT tag, ClientPlayerEntity player, ItemStack zapper) {
        if (!tag.func_74764_b("BrushParams")) {
            renderedPosition = null;
            return;
        }
        Brush brush = NBTHelper.readEnum(tag.func_74779_i("Brush"), TerrainBrushes.class).get();
        PlacementOptions placement = NBTHelper.readEnum(tag.func_74779_i("Placement"), PlacementOptions.class);
        BlockPos params = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("BrushParams"));
        brush.set(params.func_177958_n(), params.func_177956_o(), params.func_177952_p());
        renderedShape = brush.getSelectionBox();
        Vec3d start = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d range = player.func_70040_Z().func_186678_a(128.0);
        BlockRayTraceResult raytrace = player.field_70170_p.func_217299_a(new RayTraceContext(start, start.func_178787_e(range), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        if (raytrace == null || raytrace.func_216346_c() == RayTraceResult.Type.MISS) {
            renderedPosition = null;
            return;
        }
        BlockPos pos = raytrace.func_216350_a();
        renderedPosition = pos.func_177971_a((Vec3i)brush.getOffset(player.func_70040_Z(), raytrace.func_216354_b(), placement));
    }

    public static void render() {
        if (renderedPosition == null) {
            return;
        }
        GlStateManager.lineWidth((float)2.0f);
        TessellatorHelper.prepareForDrawing();
        GlStateManager.disableTexture();
        GlStateManager.translated((double)renderedPosition.func_177958_n(), (double)renderedPosition.func_177956_o(), (double)renderedPosition.func_177952_p());
        WorldRenderer.func_195463_b((VoxelShape)renderedShape, (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        GlStateManager.enableTexture();
        TessellatorHelper.cleanUpAfterDrawing();
        GlStateManager.lineWidth((float)1.0f);
    }
}

