/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.curiosities.zapper.terrainzapper;

import com.simibubi.create.foundation.block.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.item.IHaveCustomItemModel;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.modules.curiosities.zapper.PlacementPatterns;
import com.simibubi.create.modules.curiosities.zapper.ZapperItem;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.Brush;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainBrushes;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainTools;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainzapperModel;
import com.simibubi.create.modules.curiosities.zapper.terrainzapper.TerrainzapperScreen;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TerrainzapperItem
extends ZapperItem
implements IHaveCustomItemModel {
    public TerrainzapperItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void openHandgunGUI(ItemStack item, boolean b) {
        ScreenOpener.open(new TerrainzapperScreen(item, b));
    }

    @Override
    protected int getRange(ItemStack stack) {
        return 128;
    }

    @Override
    protected int getCooldownDelay(ItemStack item) {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CustomRenderedItemModel createModel(IBakedModel original) {
        return new TerrainzapperModel(original);
    }

    @Override
    public String validateUsage(ItemStack item) {
        if (!item.func_196082_o().func_74764_b("BrushParams")) {
            return Lang.translate("terrainzapper.shiftRightClickToSet", new Object[0]);
        }
        return super.validateUsage(item);
    }

    @Override
    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        TerrainTools tool = NBTHelper.readEnum(tag.func_74779_i("Tool"), TerrainTools.class);
        return !tool.requiresSelectedBlock();
    }

    @Override
    protected boolean activate(World world, PlayerEntity player, ItemStack stack, BlockState stateToUse, BlockRayTraceResult raytrace) {
        BlockPos targetPos = raytrace.func_216350_a();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        CompoundNBT tag = stack.func_196082_o();
        Brush brush = NBTHelper.readEnum(tag.func_74779_i("Brush"), TerrainBrushes.class).get();
        BlockPos params = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("BrushParams"));
        PlacementOptions option = NBTHelper.readEnum(tag.func_74779_i("Placement"), PlacementOptions.class);
        TerrainTools tool = NBTHelper.readEnum(tag.func_74779_i("Tool"), TerrainTools.class);
        brush.set(params.func_177958_n(), params.func_177956_o(), params.func_177952_p());
        targetPos = targetPos.func_177971_a((Vec3i)brush.getOffset(player.func_70040_Z(), raytrace.func_216354_b(), option));
        for (BlockPos blockPos : brush.getIncludedPositions()) {
            affectedPositions.add(targetPos.func_177971_a((Vec3i)blockPos));
        }
        PlacementPatterns.applyPattern(affectedPositions, stack);
        tool.run(world, affectedPositions, raytrace.func_216354_b(), stateToUse);
        return true;
    }
}

