/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics;

import com.simibubi.create.Create;
import com.simibubi.create.config.AllConfigs;
import com.simibubi.create.foundation.behaviour.linked.LinkBehaviour;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkNetworkHandler {
    static Map<IWorld, Map<Pair<Frequency, Frequency>, Set<LinkBehaviour>>> connections = new HashMap<IWorld, Map<Pair<Frequency, Frequency>, Set<LinkBehaviour>>>();

    public void onLoadWorld(IWorld world) {
        connections.put(world, new HashMap());
        Create.logger.debug("Prepared Redstone Network Space for " + world.func_201675_m().func_186058_p().getRegistryName());
    }

    public void onUnloadWorld(IWorld world) {
        connections.remove(world);
        Create.logger.debug("Removed Redstone Network Space for " + world.func_201675_m().func_186058_p().getRegistryName());
    }

    public Set<LinkBehaviour> getNetworkOf(LinkBehaviour actor) {
        Pair<Frequency, Frequency> key;
        Map<Pair<Frequency, Frequency>, Set<LinkBehaviour>> networksInWorld = this.networksIn((IWorld)actor.getWorld());
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new HashSet());
        }
        return networksInWorld.get(key);
    }

    public void addToNetwork(LinkBehaviour actor) {
        this.getNetworkOf(actor).add(actor);
        this.updateNetworkOf(actor);
    }

    public void removeFromNetwork(LinkBehaviour actor) {
        Set<LinkBehaviour> network = this.getNetworkOf(actor);
        network.remove(actor);
        if (network.isEmpty()) {
            this.networksIn((IWorld)actor.getWorld()).remove(actor.getNetworkKey());
            return;
        }
        this.updateNetworkOf(actor);
    }

    public void updateNetworkOf(LinkBehaviour actor) {
        LinkBehaviour other;
        Set<LinkBehaviour> network = this.getNetworkOf(actor);
        boolean powered = false;
        Iterator<LinkBehaviour> iterator = network.iterator();
        while (iterator.hasNext()) {
            other = iterator.next();
            if (other.tileEntity.func_145837_r()) {
                iterator.remove();
                continue;
            }
            World world = actor.getWorld();
            if (!world.func_195588_v(other.tileEntity.func_174877_v())) {
                iterator.remove();
                continue;
            }
            if (world.func_175625_s(other.tileEntity.func_174877_v()) != other.tileEntity) {
                iterator.remove();
                continue;
            }
            if (!RedstoneLinkNetworkHandler.withinRange(actor, other) || !other.isTransmitting()) continue;
            powered = true;
            break;
        }
        iterator = network.iterator();
        while (iterator.hasNext()) {
            other = iterator.next();
            if (other.tileEntity.func_145837_r()) {
                iterator.remove();
                continue;
            }
            if (!RedstoneLinkNetworkHandler.withinRange(actor, other) || !other.isListening()) continue;
            other.updateReceiver(powered);
        }
    }

    public static boolean withinRange(LinkBehaviour from, LinkBehaviour to) {
        return from.getPos().func_218141_a((Vec3i)to.getPos(), (double)((Integer)AllConfigs.SERVER.logistics.linkRange.get()).intValue());
    }

    public Map<Pair<Frequency, Frequency>, Set<LinkBehaviour>> networksIn(IWorld world) {
        if (!connections.containsKey(world)) {
            Create.logger.warn("Tried to Access unprepared network space of " + world.func_201675_m().func_186058_p().getRegistryName());
            return new HashMap<Pair<Frequency, Frequency>, Set<LinkBehaviour>>();
        }
        return connections.get(world);
    }

    public static class Frequency {
        private ItemStack stack;
        private Item item;
        private int color;

        public Frequency(ItemStack stack) {
            this.stack = stack;
            this.item = stack.func_77973_b();
            CompoundNBT displayTag = stack.func_179543_a("display");
            this.color = displayTag != null && displayTag.func_74764_b("color") ? displayTag.func_74762_e("color") : -1;
        }

        public ItemStack getStack() {
            return this.stack.func_77946_l();
        }

        public int hashCode() {
            return this.item.hashCode() ^ this.color;
        }

        public boolean equals(Object obj) {
            return obj instanceof Frequency ? ((Frequency)obj).item == this.item && ((Frequency)obj).color == this.color : false;
        }
    }
}

