/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.linked.LinkBehaviour;
import com.simibubi.create.modules.logistics.block.RedstoneLinkBlock;
import com.simibubi.create.modules.logistics.block.RedstoneLinkFrequencySlot;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class RedstoneLinkTileEntity
extends SmartTileEntity {
    private boolean receivedSignal;
    private boolean transmittedSignal;
    private LinkBehaviour link;
    private boolean transmitter;

    public RedstoneLinkTileEntity() {
        super(AllTileEntities.REDSTONE_BRIDGE.type);
    }

    public RedstoneLinkTileEntity(boolean transmitter) {
        this();
        this.transmitter = transmitter;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair<ValueBoxTransform, ValueBoxTransform> slots = ValueBoxTransform.Dual.makeSlots(RedstoneLinkFrequencySlot::new);
        this.link = this.transmitter ? LinkBehaviour.transmitter(this, slots, this::getSignal) : LinkBehaviour.receiver(this, slots, this::setSignal);
    }

    public boolean getSignal() {
        return this.transmittedSignal;
    }

    public void setSignal(boolean powered) {
        this.receivedSignal = powered;
    }

    public void transmit(boolean signal) {
        this.transmittedSignal = signal;
        if (this.link != null) {
            this.link.notifySignalChange();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Transmitter", this.transmitter);
        compound.func_74757_a("Receive", this.receivedSignal);
        compound.func_74757_a("Transmit", this.transmittedSignal);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.transmitter = compound.func_74767_n("Transmitter");
        super.func_145839_a(compound);
        this.receivedSignal = compound.func_74767_n("Receive");
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.link.newPosition) {
            this.transmittedSignal = compound.func_74767_n("Transmit");
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            LinkBehaviour prevlink = this.link;
            this.removeBehaviour(LinkBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.putBehaviour(this.link);
        }
        if (this.transmitter) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.REDSTONE_BRIDGE.typeOf(blockState)) {
            return;
        }
        if (this.receivedSignal != (Boolean)blockState.func_177229_b((IProperty)BlockStateProperties.field_208194_u)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)blockState.func_177231_a((IProperty)BlockStateProperties.field_208194_u));
            Direction attachedFace = ((Direction)blockState.func_177229_b((IProperty)RedstoneLinkBlock.field_176387_N)).func_176734_d();
            BlockPos attachedPos = this.field_174879_c.func_177972_a(attachedFace);
            this.field_145850_b.func_195592_c(attachedPos, this.field_145850_b.func_180495_p(attachedPos).func_177230_c());
            return;
        }
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.func_195044_w().func_177229_b((IProperty)RedstoneLinkBlock.RECEIVER) == false;
    }
}

