/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.belts.observer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.IWrenchable;
import com.simibubi.create.modules.contraptions.relays.belt.AllBeltAttachments;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.modules.logistics.block.belts.observer.BeltObserverTileEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BeltObserverBlock
extends HorizontalBlock
implements ITE<BeltObserverTileEntity>,
AllBeltAttachments.IBeltAttachment,
IWrenchable {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty BELT = BooleanProperty.func_177716_a((String)"belt");
    public static final EnumProperty<Mode> MODE = EnumProperty.func_177709_a((String)"mode", Mode.class);

    public BeltObserverBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_196656_g));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)BELT, (Comparable)Boolean.valueOf(false)));
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BeltObserverTileEntity();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == stateIn.func_177229_b((IProperty)field_185512_D)) {
            stateIn = (BlockState)stateIn.func_206870_a((IProperty)BELT, (Comparable)Boolean.valueOf(this.shouldHaveExtension(stateIn, worldIn, currentPos)));
        }
        return stateIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED, field_185512_D, BELT, MODE});
        super.func_206840_a(builder);
    }

    private boolean shouldHaveExtension(BlockState state, IWorld world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        BlockState blockState = world.func_180495_p(pos.func_177972_a(direction));
        if (!AllBlocks.BELT.typeOf(blockState)) {
            return false;
        }
        if (blockState.func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL) {
            return false;
        }
        if (blockState.func_177229_b(BeltBlock.PART) != BeltBlock.Part.MIDDLE) {
            return false;
        }
        return ((Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() != direction.func_176740_k();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction preferredFacing = null;
        for (Direction face : Direction.values()) {
            BlockState blockState;
            if (face.func_176740_k().func_200128_b() || !AllBlocks.BELT.typeOf(blockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(face))) || ((Direction)blockState.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176740_k() == face.func_176740_k() || blockState.func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL) continue;
            if (preferredFacing == null) {
                preferredFacing = face;
                continue;
            }
            preferredFacing = null;
            break;
        }
        state = preferredFacing != null ? (BlockState)state.func_206870_a((IProperty)field_185512_D, preferredFacing) : (context.func_196000_l().func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_196000_l()) : (BlockState)state.func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f()));
        state = (BlockState)state.func_206870_a((IProperty)BELT, (Comparable)Boolean.valueOf(this.shouldHaveExtension(state, (IWorld)context.func_195991_k(), context.func_195995_a())));
        return state;
    }

    @Override
    public List<BlockPos> getPotentialAttachmentPositions(IWorld world, BlockPos pos, BlockState beltState) {
        Direction side = ((Direction)beltState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176746_e();
        return Arrays.asList(pos.func_177972_a(side), pos.func_177972_a(side.func_176734_d()));
    }

    @Override
    public BlockPos getBeltPositionForAttachment(IWorld world, BlockPos pos, BlockState state) {
        return pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_185512_D));
    }

    @Override
    public boolean isAttachedCorrectly(IWorld world, BlockPos attachmentPos, BlockPos beltPos, BlockState attachmentState, BlockState beltState) {
        return (Boolean)attachmentState.func_177229_b((IProperty)BELT);
    }

    public boolean func_149744_f(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)POWERED);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_149744_f(blockState) ? 15 : 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != this || newState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)) != state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))) {
            this.onAttachmentRemoved((IWorld)worldIn, pos, state);
        }
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            TileEntityBehaviour.destroy((IEnviromentBlockReader)worldIn, pos, FilteringBehaviour.TYPE);
            worldIn.func_175713_t(pos);
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != this || oldState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)) != state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))) {
            this.onAttachmentPlaced((IWorld)worldIn, pos, state);
        }
    }

    @Override
    public boolean startProcessingItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        World world = te.func_145831_w();
        BlockState blockState = world.func_180495_p(state.attachmentPos);
        if (blockState.func_177229_b(MODE) == Mode.DETECT) {
            return false;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get((IEnviromentBlockReader)te.func_145831_w(), state.attachmentPos, FilteringBehaviour.TYPE);
        if (behaviour != null && !behaviour.test(transported.stack)) {
            return false;
        }
        world.func_175656_a(state.attachmentPos, (BlockState)blockState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_195593_d(state.attachmentPos, (Block)this);
        this.withTileEntityDo((IBlockReader)world, state.attachmentPos, BeltObserverTileEntity::resetTurnOffCooldown);
        Mode mode = (Mode)((Object)blockState.func_177229_b(MODE));
        if (mode == Mode.EJECT || mode == Mode.SPLIT) {
            ItemStack toEject;
            ItemStack copy = transported.stack.func_77946_l();
            ItemStack itemStack = toEject = mode == Mode.EJECT ? transported.stack : copy.func_77979_a(transported.stack.func_190916_E() / 2);
            if (!toEject.func_190926_b()) {
                if (!this.eject(world, toEject, state.attachmentPos, (Direction)blockState.func_177229_b((IProperty)field_185512_D))) {
                    return true;
                }
                transported.stack = mode == Mode.EJECT ? ItemStack.field_190927_a : copy;
            }
        }
        return false;
    }

    @Override
    public boolean processItem(BeltTileEntity te, TransportedItemStack transported, AllBeltAttachments.BeltAttachmentState state) {
        World world = te.func_145831_w();
        BlockState blockState = world.func_180495_p(state.attachmentPos);
        this.withTileEntityDo((IBlockReader)world, state.attachmentPos, BeltObserverTileEntity::resetTurnOffCooldown);
        Mode mode = (Mode)((Object)blockState.func_177229_b(MODE));
        if (mode == Mode.EJECT || mode == Mode.SPLIT) {
            ItemStack toEject;
            ItemStack copy = transported.stack.func_77946_l();
            ItemStack itemStack = toEject = mode == Mode.EJECT ? transported.stack : copy.func_77979_a(transported.stack.func_190916_E() / 2);
            if (!this.eject(world, toEject, state.attachmentPos, (Direction)blockState.func_177229_b((IProperty)field_185512_D))) {
                return true;
            }
            transported.stack = mode == Mode.EJECT ? ItemStack.field_190927_a : copy;
        }
        return false;
    }

    private boolean eject(World world, ItemStack stack, BlockPos observerPos, Direction facing) {
        BlockPos potentialBeltPos = observerPos.func_177967_a(facing, 2);
        TileEntity tileEntity = world.func_175625_s(potentialBeltPos);
        if (tileEntity instanceof BeltTileEntity) {
            BeltTileEntity belt = (BeltTileEntity)tileEntity;
            return belt.tryInsertingFromSide(facing, stack, false);
        }
        boolean empty = world.func_180495_p(potentialBeltPos).func_196952_d((IBlockReader)world, potentialBeltPos).func_197766_b();
        float yOffset = empty ? 0.0f : 0.5f;
        AxisAlignedBB bb = new AxisAlignedBB(empty ? potentialBeltPos : potentialBeltPos.func_177984_a());
        if (!world.func_72839_b(null, bb).isEmpty()) {
            return false;
        }
        Vec3d motion = new Vec3d(facing.func_176730_m()).func_186678_a(0.0625);
        Vec3d entityPos = VecHelper.getCenterOf((Vec3i)potentialBeltPos).func_72441_c(0.0, (double)(yOffset + 0.25f), 0.0).func_178788_d(motion);
        ItemEntity entity = new ItemEntity(world, entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c, stack);
        entity.func_213317_d(motion);
        entity.func_174867_a(5);
        world.func_184133_a(null, observerPos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.125f, 0.1f);
        world.func_217376_c((Entity)entity);
        return true;
    }

    @Override
    public boolean processEntity(BeltTileEntity te, Entity entity, AllBeltAttachments.BeltAttachmentState state) {
        if (te.func_145831_w().field_72995_K) {
            return false;
        }
        if (entity.func_213303_ch().func_72438_d(VecHelper.getCenterOf((Vec3i)te.func_174877_v())) > 0.5) {
            return false;
        }
        World world = te.func_145831_w();
        BlockState blockState = world.func_180495_p(state.attachmentPos);
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return false;
        }
        world.func_175656_a(state.attachmentPos, (BlockState)blockState.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)));
        world.func_195593_d(state.attachmentPos, (Block)this);
        this.withTileEntityDo((IBlockReader)te.func_145831_w(), state.attachmentPos, BeltObserverTileEntity::resetTurnOffCooldown);
        return false;
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.func_195593_d(pos, (Block)this);
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K) {
            world.func_180501_a(context.func_195995_a(), (BlockState)((BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_177231_a(MODE), 3);
            world.func_195593_d(context.func_195995_a(), (Block)this);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public Class<BeltObserverTileEntity> getTileEntityClass() {
        return BeltObserverTileEntity.class;
    }

    public static enum Mode implements IStringSerializable
    {
        DETECT,
        PULSE,
        EJECT,
        SPLIT;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

