/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.WrappedWorld;
import com.simibubi.create.modules.contraptions.IWrenchable;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.logistics.block.belts.tunnel.BeltTunnelShapes;
import com.simibubi.create.modules.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BeltTunnelBlock
extends Block
implements ITE<BeltTunnelTileEntity>,
IWrenchable {
    public static final IProperty<Shape> SHAPE = EnumProperty.func_177709_a((String)"shape", Shape.class);
    public static final IProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.field_208199_z;

    public BeltTunnelBlock() {
        super(Block.Properties.func_200950_a((Block)Blocks.field_150340_R));
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)Shape.STRAIGHT)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BeltTunnelShapes.getShape(state);
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BeltTunnelTileEntity();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177977_b());
        if (!AllBlocks.BELT.typeOf(blockState)) {
            return false;
        }
        if (blockState.func_177229_b(BeltBlock.SLOPE) != BeltBlock.Slope.HORIZONTAL) {
            return false;
        }
        return (Boolean)blockState.func_177229_b((IProperty)BeltBlock.CASING) != false;
    }

    public boolean canRenderInLayer(BlockState state, BlockRenderLayer layer) {
        if (BeltTunnelBlock.hasWindow(state)) {
            return layer == BlockRenderLayer.CUTOUT_MIPPED;
        }
        return super.canRenderInLayer(state, layer);
    }

    public static boolean hasWindow(BlockState state) {
        Shape shape = (Shape)((Object)state.func_177229_b(SHAPE));
        return shape == Shape.WINDOW || shape == Shape.HALFSHADE || shape == Shape.FULLSHADE;
    }

    public static boolean isStraight(BlockState state) {
        return BeltTunnelBlock.hasWindow(state) || state.func_177229_b(SHAPE) == Shape.STRAIGHT;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return BeltTunnelBlock.getTunnelState((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState tunnelState;
        if (!(worldIn instanceof WrappedWorld)) {
            this.withTileEntityDo((IBlockReader)worldIn, currentPos, BeltTunnelTileEntity::initFlaps);
        }
        if ((tunnelState = BeltTunnelBlock.getTunnelState((IBlockReader)worldIn, currentPos)).func_177229_b(HORIZONTAL_AXIS) == state.func_177229_b(HORIZONTAL_AXIS) && BeltTunnelBlock.hasWindow(tunnelState) == BeltTunnelBlock.hasWindow(state)) {
            return state;
        }
        return tunnelState;
    }

    public static void updateTunnel(World world, BlockPos pos) {
        BlockState newTunnel;
        BlockState tunnel = world.func_180495_p(pos);
        if (tunnel != (newTunnel = BeltTunnelBlock.getTunnelState((IBlockReader)world, pos))) {
            world.func_180501_a(pos, newTunnel, 3);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof BeltTunnelTileEntity) {
                ((BeltTunnelTileEntity)te).initFlaps();
            }
        }
    }

    public static List<BeltTunnelTileEntity> getSynchronizedGroup(World world, BlockPos pos, Direction flapFacing) {
        ArrayList<BeltTunnelTileEntity> group = new ArrayList<BeltTunnelTileEntity>();
        Direction searchDirection = flapFacing.func_176746_e();
        block0: for (Direction d : Arrays.asList(searchDirection, searchDirection.func_176734_d())) {
            TileEntity te;
            BlockPos currentPos = pos;
            while (world.func_195588_v(currentPos) && (te = world.func_175625_s(currentPos)) != null && te instanceof BeltTunnelTileEntity) {
                BeltTunnelTileEntity tunnel = (BeltTunnelTileEntity)te;
                if (!tunnel.syncedFlaps.containsKey(flapFacing)) continue block0;
                group.add(tunnel);
                currentPos = currentPos.func_177972_a(d);
            }
        }
        return group;
    }

    private static BlockState getTunnelState(IBlockReader reader, BlockPos pos) {
        Direction fw;
        boolean onRight;
        Direction.Axis axis;
        Direction left;
        BlockState leftState;
        BlockState state = AllBlocks.BELT_TUNNEL.get().func_176223_P();
        BlockState belt = reader.func_180495_p(pos.func_177977_b());
        if (AllBlocks.BELT.typeOf(belt)) {
            state = (BlockState)state.func_206870_a(HORIZONTAL_AXIS, (Comparable)((Direction)belt.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k());
        }
        boolean onLeft = AllBlocks.BELT.typeOf(leftState = reader.func_180495_p(pos.func_177972_a(left = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)(axis = (Direction.Axis)state.func_177229_b(HORIZONTAL_AXIS))).func_176746_e()).func_177977_b())) && ((Direction)leftState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() != axis;
        BlockState rightState = reader.func_180495_p(pos.func_177972_a(left.func_176734_d()).func_177977_b());
        boolean bl = onRight = AllBlocks.BELT.typeOf(rightState) && ((Direction)rightState.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176740_k() != axis;
        if (onLeft && onRight) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.CROSS));
        } else if (onLeft) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.T_LEFT));
        } else if (onRight) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.T_RIGHT));
        }
        if (state.func_177229_b(SHAPE) == Shape.STRAIGHT && AllBlocks.BELT_TUNNEL.typeOf(reader.func_180495_p(pos.func_177972_a(fw = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)))) && AllBlocks.BELT_TUNNEL.typeOf(reader.func_180495_p(pos.func_177972_a(fw.func_176734_d())))) {
            state = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)Shape.WINDOW));
        }
        return state;
    }

    @Override
    public ActionResultType onWrenched(BlockState state, ItemUseContext context) {
        if (this.toggleSync(context.func_195991_k(), context.func_195995_a(), context.func_196000_l())) {
            return ActionResultType.SUCCESS;
        }
        if (!BeltTunnelBlock.hasWindow(state)) {
            return IWrenchable.super.onWrenched(state, context);
        }
        Shape next = (Shape)((Object)state.func_177229_b(SHAPE));
        switch ((Shape)((Object)state.func_177229_b(SHAPE))) {
            case FULLSHADE: {
                next = Shape.WINDOW;
                break;
            }
            case HALFSHADE: {
                next = Shape.FULLSHADE;
                break;
            }
            case WINDOW: {
                next = Shape.HALFSHADE;
                break;
            }
        }
        if (!context.func_195991_k().field_72995_K) {
            context.func_195991_k().func_180501_a(context.func_195995_a(), (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)next)), 2);
        }
        return ActionResultType.SUCCESS;
    }

    private boolean toggleSync(World world, BlockPos pos, Direction face) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof BeltTunnelTileEntity)) {
            return false;
        }
        BeltTunnelTileEntity tunnel = (BeltTunnelTileEntity)te;
        return tunnel.toggleSyncForFlap(face);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (fromPos.equals((Object)pos.func_177977_b()) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
            return;
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HORIZONTAL_AXIS, SHAPE});
        super.func_206840_a(builder);
    }

    @Override
    public Class<BeltTunnelTileEntity> getTileEntityClass() {
        return BeltTunnelTileEntity.class;
    }

    public static enum Shape implements IStringSerializable
    {
        STRAIGHT,
        WINDOW,
        HALFSHADE,
        FULLSHADE,
        T_LEFT,
        T_RIGHT,
        CROSS;


        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

