/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.block.SyncedTileEntity;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.modules.logistics.block.belts.tunnel.BeltTunnelBlock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BeltTunnelTileEntity
extends SyncedTileEntity
implements ITickableTileEntity {
    public HashMap<Direction, InterpolatedChasingValue> flaps;
    public HashMap<Direction, ItemStack> syncedFlaps;
    private LazyOptional<IItemHandler> cap = LazyOptional.empty();
    private boolean initialize = true;
    private List<Pair<Direction, Boolean>> flapsToSend;

    public BeltTunnelTileEntity() {
        super(AllTileEntities.BELT_TUNNEL.type);
        this.flaps = new HashMap();
        this.syncedFlaps = new HashMap();
        this.flapsToSend = new LinkedList<Pair<Direction, Boolean>>();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Object capBelow;
            TileEntity teBelow;
            if (!this.cap.isPresent() && AllBlocks.BELT.typeOf(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())) && (teBelow = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && (capBelow = teBelow.getCapability(capability, Direction.UP).orElse(null)) != null) {
                this.cap = LazyOptional.of(() -> capBelow).cast();
            }
            return this.cap.cast();
        }
        return super.getCapability(capability, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.cap.invalidate();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT dyedFlapsNBT = new CompoundNBT();
        this.syncedFlaps.forEach((direction, pair) -> dyedFlapsNBT.func_74757_a(direction.name(), true));
        compound.func_218657_a("syncedFlaps", (INBT)dyedFlapsNBT);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        if (compound.func_74764_b("syncedFlaps")) {
            this.syncedFlaps.clear();
            CompoundNBT dyedFlapsNBT = compound.func_74775_l("syncedFlaps");
            for (Direction direction : Direction.values()) {
                if (!dyedFlapsNBT.func_74764_b(direction.name())) continue;
                this.syncedFlaps.put(direction, ItemStack.field_190927_a);
            }
        }
        super.func_145839_a(compound);
    }

    public boolean toggleSyncForFlap(Direction face) {
        if (!this.flaps.containsKey(face)) {
            return false;
        }
        if (this.syncedFlaps.containsKey(face)) {
            this.syncedFlaps.remove(face);
        } else {
            this.syncedFlaps.put(face, ItemStack.field_190927_a);
        }
        this.func_70296_d();
        this.sendData();
        return true;
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT tag) {
        CompoundNBT writeToClient = super.writeToClient(tag);
        if (!this.flapsToSend.isEmpty()) {
            ListNBT flapsNBT = new ListNBT();
            for (Pair<Direction, Boolean> pair : this.flapsToSend) {
                CompoundNBT flap = new CompoundNBT();
                flap.func_74768_a("Flap", ((Direction)pair.getKey()).func_176745_a());
                flap.func_74757_a("FlapInward", ((Boolean)pair.getValue()).booleanValue());
                flapsNBT.add((Object)flap);
            }
            writeToClient.func_218657_a("Flaps", (INBT)flapsNBT);
            this.flapsToSend.clear();
        }
        return writeToClient;
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        super.readClientUpdate(tag);
        if (tag.func_74764_b("Flaps")) {
            ListNBT flapsNBT = tag.func_150295_c("Flaps", 10);
            for (INBT inbt : flapsNBT) {
                CompoundNBT flap = (CompoundNBT)inbt;
                Direction side = Direction.func_82600_a((int)flap.func_74762_e("Flap"));
                this.flap(side, flap.func_74767_n("FlapInward"));
            }
        } else {
            this.initFlaps();
        }
    }

    public void initFlaps() {
        if (!this.field_145850_b.field_72995_K) {
            this.sendData();
        }
        this.initialize = false;
        this.flaps.clear();
        BlockState tunnelState = this.func_195044_w();
        for (Direction direction : Direction.values()) {
            if (direction.func_176740_k().func_200128_b() || AllBlocks.BELT_TUNNEL.typeOf(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(direction)))) continue;
            if (direction.func_176740_k() != tunnelState.func_177229_b((IProperty)BlockStateProperties.field_208199_z)) {
                boolean positive = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ^ direction.func_176740_k() == Direction.Axis.Z;
                BeltTunnelBlock.Shape shape = (BeltTunnelBlock.Shape)((Object)tunnelState.func_177229_b(BeltTunnelBlock.SHAPE));
                if (BeltTunnelBlock.isStraight(tunnelState) || positive && shape == BeltTunnelBlock.Shape.T_LEFT || !positive && shape == BeltTunnelBlock.Shape.T_RIGHT) continue;
            }
            this.flaps.put(direction, new InterpolatedChasingValue().target(0.0f).withSpeed(0.05f));
        }
    }

    public void flap(Direction side, boolean inward) {
        if (this.field_145850_b.field_72995_K) {
            if (this.flaps.containsKey(side)) {
                this.flaps.get(side).set(inward ? -1.0f : 1.0f);
            }
            return;
        }
        this.flapsToSend.add((Pair<Direction, Boolean>)Pair.of((Object)side, (Object)inward));
    }

    public void func_73660_a() {
        if (this.initialize) {
            this.initFlaps();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.flapsToSend.isEmpty()) {
                this.sendData();
            }
            return;
        }
        this.flaps.forEach((d, value) -> value.tick());
    }
}

