/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.foundation.block.SafeTileEntityRendererFast;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.SuperByteBuffer;
import com.simibubi.create.modules.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class BeltTunnelTileEntityRenderer
extends SafeTileEntityRendererFast<BeltTunnelTileEntity> {
    @Override
    public void renderFast(BeltTunnelTileEntity te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        SuperByteBuffer flapBuffer = AllBlockPartials.BELT_TUNNEL_FLAP.renderOn(te.func_195044_w());
        SuperByteBuffer indicatorBuffer = AllBlockPartials.BELT_TUNNEL_INDICATOR.renderOn(te.func_195044_w());
        BlockPos pos = te.func_174877_v();
        World world = this.func_178459_a();
        for (Direction direction : Direction.values()) {
            if (!te.flaps.containsKey(direction)) continue;
            float horizontalAngle = direction.func_185119_l() + 90.0f;
            if (direction.func_176740_k() != Direction.Axis.X) {
                horizontalAngle += 180.0f;
            }
            float flapPivotX = -0.9375f;
            float flapPivotY = -0.5f;
            float flapPivotZ = 0.0f;
            for (int segment = 0; segment <= 3; ++segment) {
                float f = te.flaps.get(direction).get(partialTicks);
                if (direction.func_176740_k() == Direction.Axis.X) {
                    f *= -1.0f;
                }
                float intensity = segment == 3 ? 1.5f : (float)(segment + 1);
                float abs = Math.abs(f);
                float flapAngle = MathHelper.func_76126_a((float)((float)((double)(1.0f - abs) * Math.PI * (double)intensity))) * 30.0f * -f;
                flapAngle = (float)((double)(flapAngle / 180.0f) * Math.PI);
                if (te.syncedFlaps.containsKey(direction)) {
                    float lightIntensity = abs * abs * abs;
                    int color = ColorHelper.mixColors(0x808080, 0xFFFFFF, lightIntensity);
                    indicatorBuffer.rotateCentered(Direction.Axis.Y, (float)((double)((horizontalAngle + 90.0f) / 180.0f) * Math.PI)).translate(x, y, z).color(color).light(world.func_217338_b(pos, (int)(12.0f * lightIntensity))).renderInto(buffer);
                }
                flapBuffer.translate(0.0f, 0.0f, (float)(-segment * 3) / 16.0f);
                flapBuffer.translate(flapPivotX, flapPivotY, flapPivotZ).rotate(Direction.Axis.Z, flapAngle).translate(-flapPivotX, -flapPivotY, -flapPivotZ);
                flapBuffer.rotateCentered(Direction.Axis.Y, (float)((double)(horizontalAngle / 180.0f) * Math.PI)).translate(x, y, z);
                flapBuffer.light(te.func_195044_w().func_215684_a((IEnviromentBlockReader)world, pos)).renderInto(buffer);
            }
        }
    }
}

