/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.extractor;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.AllShapes;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.components.contraptions.IPortableBlock;
import com.simibubi.create.modules.contraptions.components.contraptions.MovementBehaviour;
import com.simibubi.create.modules.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.modules.logistics.block.belts.BeltAttachableLogisticalBlock;
import com.simibubi.create.modules.logistics.block.extractor.ExtractorMovementBehaviour;
import com.simibubi.create.modules.logistics.block.extractor.ExtractorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ExtractorBlock
extends BeltAttachableLogisticalBlock
implements IPortableBlock {
    public static BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final MovementBehaviour MOVEMENT = new ExtractorMovementBehaviour();

    public ExtractorBlock() {
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isVertical() {
        return false;
    }

    @Override
    protected BlockState getVerticalDefaultState() {
        return AllBlocks.VERTICAL_EXTRACTOR.getDefault();
    }

    @Override
    protected BlockState getHorizontalDefaultState() {
        return AllBlocks.EXTRACTOR.getDefault();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a((StateContainer.Builder<Block, BlockState>)builder.func_206894_a(new IProperty[]{POWERED}));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ExtractorTileEntity();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(this.reactsToRedstone() && context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn.field_72995_K) {
            return;
        }
        if (!this.reactsToRedstone()) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if (previouslyPowered != worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }

    protected boolean reactsToRedstone() {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AllShapes.EXTRACTOR.get(ExtractorBlock.getBlockFacing(state));
    }

    public static Vec3d getFilterSlotPosition(BlockState state) {
        float verticalOffset = state.func_177230_c() instanceof ExtractorBlock ? 10.5f : 12.5f;
        Vec3d offsetForHorizontal = VecHelper.voxelSpace(8.0, verticalOffset, 14.0);
        Vec3d offsetForUpward = VecHelper.voxelSpace(8.0, 14.15f, 3.5);
        Vec3d offsetForDownward = VecHelper.voxelSpace(8.0, 1.85f, 3.5);
        Vec3d vec = offsetForHorizontal;
        float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)field_185512_D));
        if (AttachedLogisticalBlock.isVertical(state)) {
            vec = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? offsetForUpward : offsetForDownward;
        }
        return VecHelper.rotateCentered(vec, yRot, Direction.Axis.Y);
    }

    public static Vec3d getFilterSlotOrientation(BlockState state) {
        float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)field_185512_D));
        float zRot = AttachedLogisticalBlock.isVertical(state) ? 0.0f : 90.0f;
        return new Vec3d(0.0, (double)yRot, (double)zRot);
    }

    @Override
    public MovementBehaviour getMovementBehaviour() {
        return MOVEMENT;
    }

    public static class Vertical
    extends ExtractorBlock {
        @Override
        protected boolean isVertical() {
            return true;
        }
    }
}

