/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.extractor;

import com.simibubi.create.foundation.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.modules.logistics.block.transposer.TransposerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;

public class ExtractorSlots {

    public static class Link
    extends ValueBoxTransform.Dual {
        Vec3d offsetForHorizontal = VecHelper.voxelSpace(11.5, 4.0, 14.0);
        Vec3d offsetForUpward = VecHelper.voxelSpace(10.0, 14.0, 11.5);
        Vec3d offsetForDownward = VecHelper.voxelSpace(10.0, 2.0, 11.5);

        public Link(boolean first) {
            super(first);
        }

        @Override
        protected Vec3d getLocation(BlockState state) {
            Vec3d location = this.offsetForHorizontal;
            if (state.func_177230_c() instanceof TransposerBlock) {
                location = location.func_72441_c(0.0, 0.125, 0.0);
            }
            if (!this.isFirst()) {
                location = location.func_72441_c(0.0, 0.25, 0.0);
            }
            if (AttachedLogisticalBlock.isVertical(state)) {
                Vec3d vec3d = location = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? this.offsetForUpward : this.offsetForDownward;
                if (!this.isFirst()) {
                    location = location.func_72441_c(-0.25, 0.0, 0.0);
                }
            }
            float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            location = VecHelper.rotateCentered(location, yRot, Direction.Axis.Y);
            return location;
        }

        @Override
        protected Vec3d getOrientation(BlockState state) {
            float horizontalAngle = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            boolean vertical = AttachedLogisticalBlock.isVertical(state);
            float xRot = vertical ? (float)((Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? 90 : 270) : 0.0f;
            float yRot = vertical ? horizontalAngle + 180.0f : horizontalAngle + 270.0f;
            return new Vec3d((double)xRot, (double)yRot, 0.0);
        }
    }

    static class Filter
    extends ValueBoxTransform {
        Vec3d offsetForHorizontal = VecHelper.voxelSpace(8.0, 10.5, 14.0);
        Vec3d offsetForUpward = VecHelper.voxelSpace(8.0, 14.15f, 3.5);
        Vec3d offsetForDownward = VecHelper.voxelSpace(8.0, 1.85f, 3.5);

        Filter() {
        }

        @Override
        protected Vec3d getLocation(BlockState state) {
            Vec3d location = this.offsetForHorizontal;
            if (state.func_177230_c() instanceof TransposerBlock) {
                location = location.func_72441_c(0.0, 0.125, 0.0);
            }
            if (AttachedLogisticalBlock.isVertical(state)) {
                location = (Boolean)state.func_177229_b((IProperty)AttachedLogisticalBlock.UPWARD) != false ? this.offsetForUpward : this.offsetForDownward;
            }
            return this.rotateHorizontally(state, location);
        }

        @Override
        protected Vec3d getOrientation(BlockState state) {
            float yRot = AngleHelper.horizontalAngle((Direction)state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            float zRot = AttachedLogisticalBlock.isVertical(state) ? 0.0f : 90.0f;
            return new Vec3d(0.0, (double)yRot, (double)zRot);
        }
    }
}

