/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.funnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.behaviour.base.SmartTileEntity;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InsertingBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InventoryManagementBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.modules.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.modules.logistics.block.funnel.FunnelFilterSlot;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;

public class FunnelTileEntity
extends SmartTileEntity {
    private FilteringBehaviour filtering;
    private InsertingBehaviour inserting;
    private ItemStack justEaten;

    public FunnelTileEntity() {
        super(AllTileEntities.BELT_FUNNEL.type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FunnelFilterSlot()).withCallback(this::filterChanged);
        behaviours.add(this.filtering);
        this.inserting = new InsertingBehaviour(this, InventoryManagementBehaviour.Attachments.toward(() -> AttachedLogisticalBlock.getBlockFacing(this.func_195044_w())));
        behaviours.add(this.inserting);
    }

    public void filterChanged(ItemStack stack) {
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT tag) {
        if (this.justEaten != null) {
            tag.func_218657_a("Nom", (INBT)this.justEaten.serializeNBT());
            this.justEaten = null;
        }
        return super.writeToClient(tag);
    }

    @Override
    public void readClientUpdate(CompoundNBT tag) {
        super.readClientUpdate(tag);
        if (tag.func_74764_b("Nom")) {
            this.justEaten = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("Nom"));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && this.justEaten != null) {
            this.spawnParticles(this.justEaten);
            this.justEaten = null;
        }
    }

    public ItemStack tryToInsert(ItemStack stack) {
        if (!this.filtering.test(stack)) {
            return stack;
        }
        ItemStack remainder = ItemStack.field_190927_a;
        BeltTileEntity targetingBelt = this.getTargetingBelt();
        if (targetingBelt != null) {
            Direction facing = AttachedLogisticalBlock.getBlockFacing(this.func_195044_w());
            if (!targetingBelt.tryInsertingFromSide(facing, stack.func_77946_l(), false)) {
                remainder = stack;
            }
        } else {
            remainder = this.inserting.insert(stack.func_77946_l(), false);
        }
        if (remainder.func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, AllSoundEvents.BLOCK_FUNNEL_EAT.get(), SoundCategory.BLOCKS, 0.125f, 1.0f);
            }
            this.justEaten = stack.func_77946_l();
        }
        if (remainder.func_190916_E() != stack.func_190916_E()) {
            this.sendData();
        }
        return remainder;
    }

    protected BeltTileEntity getTargetingBelt() {
        BlockPos targetPos = this.field_174879_c.func_177972_a(AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()));
        if (!AllBlocks.BELT.typeOf(this.field_145850_b.func_180495_p(targetPos))) {
            return null;
        }
        return BeltHelper.getSegmentTE((IWorld)this.field_145850_b, targetPos);
    }

    public void spawnParticles(ItemStack stack) {
        Vec3i directionVec = ((Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176730_m();
        float xSpeed = (float)(directionVec.func_177958_n() * 1) / 8.0f;
        float zSpeed = (float)(directionVec.func_177952_p() * 1) / 8.0f;
        Vec3d vec = VecHelper.getCenterOf((Vec3i)this.field_174879_c);
        this.field_145850_b.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec.field_72450_a, vec.field_72448_b - 0.5625, vec.field_72449_c, (double)xSpeed, 0.1666666716337204, (double)zSpeed);
    }
}

