/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.inventories;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.modules.logistics.block.inventories.CrateTileEntity;
import com.simibubi.create.modules.logistics.block.inventories.FlexcrateContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FlexcrateTileEntity
extends CrateTileEntity
implements INamedContainerProvider {
    public Inv inventory = new Inv();
    public int allowedAmount = 512;
    public int itemCount = 10;
    protected LazyOptional<IItemHandler> invHandler = LazyOptional.of(() -> this.inventory);

    public FlexcrateTileEntity() {
        this(AllTileEntities.FLEXCRATE.type);
    }

    public FlexcrateTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return new FlexcrateContainer(id, inventory, this);
    }

    public FlexcrateTileEntity getOtherCrate() {
        if (!AllBlocks.FLEXCRATE.typeOf(this.func_195044_w())) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        if (tileEntity instanceof FlexcrateTileEntity) {
            return (FlexcrateTileEntity)tileEntity;
        }
        return null;
    }

    public FlexcrateTileEntity getMainCrate() {
        if (this.isSecondaryCrate()) {
            return this.getOtherCrate();
        }
        return this;
    }

    public void onSplit() {
        int slot;
        FlexcrateTileEntity other = this.getOtherCrate();
        if (other == null) {
            return;
        }
        if (other == this.getMainCrate()) {
            other.onSplit();
            return;
        }
        other.allowedAmount = Math.max(1, this.allowedAmount - 1024);
        for (slot = 0; slot < other.inventory.getSlots(); ++slot) {
            other.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        for (slot = 16; slot < this.inventory.getSlots(); ++slot) {
            other.inventory.setStackInSlot(slot - 16, this.inventory.getStackInSlot(slot));
            this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
        }
        this.allowedAmount = Math.min(1024, this.allowedAmount);
        this.invHandler.invalidate();
        this.invHandler = LazyOptional.of(() -> this.inventory);
        other.invHandler.invalidate();
        other.invHandler = LazyOptional.of(() -> other.inventory);
    }

    public void onDestroyed() {
        int slot;
        FlexcrateTileEntity other = this.getOtherCrate();
        if (other == null) {
            for (int slot2 = 0; slot2 < this.inventory.getSlots(); ++slot2) {
                this.drop(slot2);
            }
            return;
        }
        FlexcrateTileEntity main = this.getMainCrate();
        if (this == main) {
            for (slot = 0; slot < this.inventory.getSlots(); ++slot) {
                other.inventory.setStackInSlot(slot, this.inventory.getStackInSlot(slot));
                this.inventory.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            other.allowedAmount = Math.min(1024, this.allowedAmount);
        }
        for (slot = 16; slot < other.inventory.getSlots(); ++slot) {
            other.drop(slot);
        }
        other.invHandler.invalidate();
        other.invHandler = LazyOptional.of(() -> other.inventory);
    }

    private void drop(int slot) {
        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.getStackInSlot(slot));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("Main", true);
        compound.func_74768_a("AllowedAmount", this.allowedAmount);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.allowedAmount = compound.func_74762_e("AllowedAmount");
        this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        super.func_145839_a(compound);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().toString());
    }

    public void sendToContainer(PacketBuffer buffer) {
        buffer.func_179255_a(this.func_174877_v());
        buffer.func_150786_a(this.func_189517_E_());
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.invHandler.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        FlexcrateTileEntity mainCrate;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (mainCrate = this.getMainCrate()) != null && mainCrate.invHandler != null && mainCrate.invHandler.isPresent()) {
            return mainCrate.invHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public class Inv
    extends ItemStackHandler {
        public Inv() {
            super(32);
        }

        public int getSlotLimit(int slot) {
            if (slot < FlexcrateTileEntity.this.allowedAmount / 64) {
                return super.getSlotLimit(slot);
            }
            if (slot == FlexcrateTileEntity.this.allowedAmount / 64) {
                return FlexcrateTileEntity.this.allowedAmount % 64;
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot > FlexcrateTileEntity.this.allowedAmount / 64) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            FlexcrateTileEntity.this.func_70296_d();
            FlexcrateTileEntity.this.itemCount = 0;
            for (int i = 0; i < this.getSlots(); ++i) {
                FlexcrateTileEntity.this.itemCount += this.getStackInSlot(i).func_190916_E();
            }
        }
    }
}

