/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.block.transposer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.foundation.behaviour.base.TileEntityBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InsertingBehaviour;
import com.simibubi.create.foundation.behaviour.inventory.InventoryManagementBehaviour;
import com.simibubi.create.modules.contraptions.base.KineticTileEntity;
import com.simibubi.create.modules.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.modules.logistics.block.AttachedLogisticalBlock;
import com.simibubi.create.modules.logistics.block.extractor.ExtractorTileEntity;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransposerTileEntity
extends ExtractorTileEntity {
    private InsertingBehaviour inserting;

    public TransposerTileEntity() {
        this(AllTileEntities.TRANSPOSER.type);
    }

    protected TransposerTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.inserting = new InsertingBehaviour(this, InventoryManagementBehaviour.Attachments.toward(() -> AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()).func_176734_d()));
        behaviours.add(this.inserting);
        this.applyFilteringCallbacks();
    }

    public void applyFilteringCallbacks() {
        this.extracting.withAmountThreshold(this::amountToExtract).withAdditionalFilter(this::shouldExtract);
    }

    public void filterChanged(ItemStack stack) {
    }

    public int amountToExtract(ItemStack stack) {
        ItemStack tester = stack.func_77946_l();
        tester.func_190920_e(64);
        return 64 - this.inserting.insert(tester, true).func_190916_E();
    }

    public boolean shouldExtract(ItemStack stack) {
        if (this.isTargetingBelt()) {
            Direction facing = AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()).func_176734_d();
            BlockPos targetPos = this.field_174879_c.func_177972_a(facing);
            BeltTileEntity te = (BeltTileEntity)this.field_145850_b.func_175625_s(targetPos);
            return te.tryInsertingFromSide(facing, stack, true);
        }
        if (this.filtering.anyAmount()) {
            return true;
        }
        return this.inserting.insert(stack, true).func_190926_b();
    }

    @Override
    protected boolean isTargetingBelt() {
        BlockPos targetPos = this.field_174879_c.func_177972_a(AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()).func_176734_d());
        if (!AllBlocks.BELT.typeOf(this.field_145850_b.func_180495_p(targetPos))) {
            return false;
        }
        TileEntity te = this.field_145850_b.func_175625_s(targetPos);
        if (te == null || !(te instanceof BeltTileEntity)) {
            return false;
        }
        return ((KineticTileEntity)te).getSpeed() != 0.0f;
    }

    @Override
    protected boolean canExtract() {
        return this.inserting.getInventory() != null;
    }

    @Override
    public void onExtract(ItemStack stack) {
        Direction facing;
        BlockPos targetPos;
        BeltTileEntity te;
        if (this.isTargetingBelt() && (te = (BeltTileEntity)this.field_145850_b.func_175625_s(targetPos = this.field_174879_c.func_177972_a(facing = AttachedLogisticalBlock.getBlockFacing(this.func_195044_w()).func_176734_d()))).tryInsertingFromSide(facing, stack, false)) {
            return;
        }
        ItemStack remainder = this.inserting.insert(stack, false);
        if (!remainder.func_190926_b()) {
            remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.extracting.getInventory(), (ItemStack)remainder, (boolean)false);
        }
        if (!remainder.func_190926_b()) {
            super.onExtract(remainder);
        }
    }
}

