/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.logistics.item.filter;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllPackets;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.modules.logistics.item.filter.AbstractFilterContainer;
import com.simibubi.create.modules.logistics.item.filter.FilterScreenPacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractFilterScreen<F extends AbstractFilterContainer>
extends AbstractSimiContainerScreen<F> {
    protected ScreenResources background;
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F container, PlayerInventory inv, ITextComponent title, ScreenResources background) {
        super(container, inv, title);
        this.background = background;
    }

    protected void init() {
        this.setWindowSize(this.background.width + 80, this.background.height + ScreenResources.PLAYER_INVENTORY.height + 20);
        super.init();
        this.widgets.clear();
        this.resetButton = new IconButton(this.field_147003_i + 15, this.field_147009_r + this.background.height - 30, ScreenResources.I_TRASH);
        this.confirmButton = new IconButton(this.field_147003_i + 159, this.field_147009_r + this.background.height - 30, ScreenResources.I_CONFIRM);
        this.widgets.add(this.resetButton);
        this.widgets.add(this.confirmButton);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        this.background.draw((AbstractGui)this, x, y);
        int invX = x + 50;
        int invY = y + this.background.height + 10;
        ScreenResources.PLAYER_INVENTORY.draw((AbstractGui)this, invX, invY);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(invX + 7), (float)(invY + 6), 0x666666);
        this.font.func_211126_b(I18n.func_135052_a((String)((AbstractFilterContainer)this.field_147002_h).filterItem.func_77977_a(), (Object[])new Object[0]), (float)(x + 15), (float)(y + 9), 5984311);
        RenderHelper.func_74520_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(this.field_147003_i + this.background.width + 0), (double)(this.field_147009_r + this.background.height - 60), (double)0.0);
        GlStateManager.scaled((double)5.0, (double)5.0, (double)5.0);
        this.itemRenderer.func_175042_a(((AbstractFilterContainer)this.field_147002_h).filterItem, 0, 0);
        GlStateManager.popMatrix();
    }

    public void tick() {
        this.handleTooltips();
        super.tick();
        this.handleIndicators();
        if (!((AbstractFilterContainer)this.field_147002_h).player.func_184614_ca().equals(((AbstractFilterContainer)this.field_147002_h).filterItem, false)) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    public void handleIndicators() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            button.active = this.isButtonEnabled(button);
        }
        for (Widget w : this.widgets) {
            if (!(w instanceof Indicator)) continue;
            ((Indicator)w).state = this.isIndicatorOn((Indicator)w) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add(TooltipHelper.holdShift(ItemDescription.Palette.Yellow, AbstractFilterScreen.hasShiftDown()));
        }
        if (AbstractFilterScreen.hasShiftDown()) {
            List<String> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), tooltipDescriptions.get(i));
            }
        }
    }

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<String> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, String tooltip) {
        if (!button.isHovered()) {
            return;
        }
        List<String> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutString(tooltip, TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        boolean mouseClicked = super.mouseClicked(x, y, button);
        if (button == 0) {
            if (this.confirmButton.isHovered()) {
                this.minecraft.field_71439_g.func_71053_j();
                return true;
            }
            if (this.resetButton.isHovered()) {
                ((AbstractFilterContainer)this.field_147002_h).clearContents();
                this.contentsCleared();
                this.sendOptionUpdate(FilterScreenPacket.Option.CLEAR);
                return true;
            }
        }
        return mouseClicked;
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.channel.sendToServer((Object)new FilterScreenPacket(option));
    }
}

