/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics;

import com.google.common.collect.Sets;
import com.simibubi.create.modules.schematics.ItemRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MaterialChecklist {
    public Map<Item, Integer> gathered;
    public Map<Item, Integer> required = new HashMap<Item, Integer>();
    public Map<Item, Integer> damageRequired = new HashMap<Item, Integer>();
    public boolean blocksNotLoaded;

    public MaterialChecklist() {
        this.gathered = new HashMap<Item, Integer>();
    }

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemStack stack : requirement.requiredItems) {
            if (requirement.getUsage() == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack);
            }
            if (requirement.getUsage() != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack);
        }
    }

    private void putOrIncrement(Map<Item, Integer> map, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_190931_a) {
            return;
        }
        if (map.containsKey(item)) {
            map.put(item, map.get(item) + stack.func_190916_E());
        } else {
            map.put(item, stack.func_190916_E());
        }
    }

    public void collect(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.required.containsKey(item) || this.damageRequired.containsKey(item)) {
            if (this.gathered.containsKey(item)) {
                this.gathered.put(item, this.gathered.get(item) + stack.func_190916_E());
            } else {
                this.gathered.put(item, stack.func_190916_E());
            }
        }
    }

    public ItemStack createItem() {
        ItemStack book = new ItemStack((IItemProvider)Items.field_151164_bB);
        CompoundNBT tag = book.func_196082_o();
        ListNBT pages = new ListNBT();
        int itemsWritten = 0;
        StringBuilder string = new StringBuilder("{\"text\":\"");
        if (this.blocksNotLoaded) {
            string.append("\n" + TextFormatting.RED + "* Disclaimer *\n\n");
            string.append("Material List may be inaccurate due to relevant chunks not being loaded.");
            string.append("\"}");
            pages.add((Object)new StringNBT(string.toString()));
            string = new StringBuilder("{\"text\":\"");
        }
        ArrayList keys = new ArrayList(Sets.union(this.required.keySet(), this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            Locale locale = Locale.ENGLISH;
            String name1 = new TranslationTextComponent(item1.func_77658_a(), new Object[0]).func_150254_d().toLowerCase(locale);
            String name2 = new TranslationTextComponent(item2.func_77658_a(), new Object[0]).func_150254_d().toLowerCase(locale);
            return name1.compareTo(name2);
        });
        ArrayList<Item> completed = new ArrayList<Item>();
        for (Item item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey(item)) {
                amount -= this.gathered.get(item).intValue();
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 6) {
                itemsWritten = 0;
                string.append("\"}");
                pages.add((Object)new StringNBT(string.toString()));
                string = new StringBuilder("{\"text\":\"");
            }
            ++itemsWritten;
            string.append(this.unfinishedEntry(new ItemStack((IItemProvider)item), amount));
        }
        for (Item item : completed) {
            if (itemsWritten == 6) {
                itemsWritten = 0;
                string.append("\"}");
                pages.add((Object)new StringNBT(string.toString()));
                string = new StringBuilder("{\"text\":\"");
            }
            ++itemsWritten;
            string.append(this.gatheredEntry(new ItemStack((IItemProvider)item), this.getRequiredAmount(item)));
        }
        string.append("\"}");
        pages.add((Object)new StringNBT(string.toString()));
        tag.func_218657_a("pages", (INBT)pages);
        tag.func_74778_a("author", "Schematicannon");
        tag.func_74778_a("title", TextFormatting.BLUE + "Material Checklist");
        book.func_77982_d(tag);
        return book;
    }

    public Integer getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault(item, 0);
        if (this.damageRequired.containsKey(item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.get(item).intValue() / (float)new ItemStack((IItemProvider)item).func_77958_k()));
        }
        return amount;
    }

    private String gatheredEntry(ItemStack item, int amount) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        TranslationTextComponent tc = new TranslationTextComponent(item.func_77977_a(), new Object[0]);
        return TextFormatting.DARK_GREEN + tc.func_150254_d() + " \\u2714\n x" + amount + TextFormatting.GRAY + " | " + stacks + "\\u25A4 +" + remainder + "\n";
    }

    private String unfinishedEntry(ItemStack item, int amount) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        TranslationTextComponent tc = new TranslationTextComponent(item.func_77977_a(), new Object[0]);
        return TextFormatting.BLUE + tc.func_150254_d() + "\n x" + amount + TextFormatting.GRAY + " | " + stacks + "\\u25A4 +" + remainder + "\n";
    }
}

