/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.modules.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.modules.contraptions.relays.belt.item.BeltConnectorItem;
import com.simibubi.create.modules.contraptions.relays.elementary.ShaftBlock;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class LaunchedItem {
    public int totalTicks;
    public int ticksRemaining;
    public BlockPos target;
    public ItemStack stack;

    private LaunchedItem(BlockPos start, BlockPos target, ItemStack stack) {
        this(target, stack, LaunchedItem.ticksForDistance(start, target), LaunchedItem.ticksForDistance(start, target));
    }

    private static int ticksForDistance(BlockPos start, BlockPos target) {
        return (int)Math.max(10.0f, MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)target.func_177951_i((Vec3i)start))) * 4.0f);
    }

    LaunchedItem() {
    }

    private LaunchedItem(BlockPos target, ItemStack stack, int ticksLeft, int total) {
        this.target = target;
        this.stack = stack;
        this.totalTicks = total;
        this.ticksRemaining = ticksLeft;
    }

    public boolean update(World world) {
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        this.place(world);
        return true;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT c = new CompoundNBT();
        c.func_74768_a("TotalTicks", this.totalTicks);
        c.func_74768_a("TicksLeft", this.ticksRemaining);
        c.func_218657_a("Stack", (INBT)this.stack.serializeNBT());
        c.func_218657_a("Target", (INBT)NBTUtil.func_186859_a((BlockPos)this.target));
        return c;
    }

    public static LaunchedItem fromNBT(CompoundNBT c) {
        ForBelt launched = c.func_74764_b("Length") ? new ForBelt() : (c.func_74764_b("BlockState") ? new ForBlockState() : new ForEntity());
        ((LaunchedItem)launched).readNBT(c);
        return launched;
    }

    abstract void place(World var1);

    void readNBT(CompoundNBT c) {
        this.target = NBTUtil.func_186861_c((CompoundNBT)c.func_74775_l("Target"));
        this.ticksRemaining = c.func_74762_e("TicksLeft");
        this.totalTicks = c.func_74762_e("TotalTicks");
        this.stack = ItemStack.func_199557_a((CompoundNBT)c.func_74775_l("Stack"));
    }

    public static class ForEntity
    extends LaunchedItem {
        public Entity entity;
        private CompoundNBT deferredTag;

        ForEntity() {
        }

        public ForEntity(BlockPos start, BlockPos target, ItemStack stack, Entity entity) {
            super(start, target, stack);
            this.entity = entity;
        }

        @Override
        public boolean update(World world) {
            if (this.deferredTag != null && this.entity == null) {
                try {
                    Optional loadEntityUnchecked = EntityType.func_220330_a((CompoundNBT)this.deferredTag, (World)world);
                    if (!loadEntityUnchecked.isPresent()) {
                        return true;
                    }
                    this.entity = (Entity)loadEntityUnchecked.get();
                }
                catch (Exception var3) {
                    return true;
                }
                this.deferredTag = null;
            }
            return super.update(world);
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT serializeNBT = super.serializeNBT();
            if (this.entity != null) {
                serializeNBT.func_218657_a("Entity", (INBT)this.entity.serializeNBT());
            }
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundNBT nbt) {
            super.readNBT(nbt);
            if (nbt.func_74764_b("Entity")) {
                this.deferredTag = nbt.func_74775_l("Entity");
            }
        }

        @Override
        void place(World world) {
            world.func_217376_c(this.entity);
        }
    }

    public static class ForBelt
    extends ForBlockState {
        public int length;

        public ForBelt() {
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT serializeNBT = super.serializeNBT();
            serializeNBT.func_74768_a("Length", this.length);
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundNBT nbt) {
            this.length = nbt.func_74762_e("Length");
            super.readNBT(nbt);
        }

        public ForBelt(BlockPos start, BlockPos target, ItemStack stack, BlockState state, int length) {
            super(start, target, stack, state);
            this.length = length;
        }

        @Override
        void place(World world) {
            boolean isStart = this.state.func_177229_b(BeltBlock.PART) == BeltBlock.Part.START;
            BlockPos offset = BeltBlock.nextSegmentPosition(this.state, BlockPos.field_177992_a, isStart);
            int i = this.length - 1;
            Direction.Axis axis = ((Direction)this.state.func_177229_b(BeltBlock.HORIZONTAL_FACING)).func_176746_e().func_176740_k();
            world.func_175656_a(this.target, (BlockState)AllBlocks.SHAFT.getDefault().func_206870_a((IProperty)ShaftBlock.AXIS, (Comparable)axis));
            BeltConnectorItem.createBelts(world, this.target, this.target.func_177982_a(offset.func_177958_n() * i, offset.func_177956_o() * i, offset.func_177952_p() * i));
        }
    }

    public static class ForBlockState
    extends LaunchedItem {
        public BlockState state;

        ForBlockState() {
        }

        public ForBlockState(BlockPos start, BlockPos target, ItemStack stack, BlockState state) {
            super(start, target, stack);
            this.state = state;
        }

        @Override
        public CompoundNBT serializeNBT() {
            CompoundNBT serializeNBT = super.serializeNBT();
            serializeNBT.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.state));
            return serializeNBT;
        }

        @Override
        void readNBT(CompoundNBT nbt) {
            super.readNBT(nbt);
            this.state = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("BlockState"));
        }

        @Override
        void place(World world) {
            if (this.state.func_196959_b((IProperty)BlockStateProperties.field_208181_h)) {
                this.state = (BlockState)this.state.func_206870_a((IProperty)BlockStateProperties.field_208181_h, (Comparable)Boolean.valueOf(false));
            }
            if (AllBlocks.BELT.typeOf(this.state)) {
                world.func_180501_a(this.target, this.state, 2);
                return;
            }
            world.func_180501_a(this.target, this.state, 18);
            this.state.func_177230_c().func_180633_a(world, this.target, this.state, null, this.stack);
        }
    }
}

