/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.TextInputPromptScreen;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.ChasingAABBOutline;
import com.simibubi.create.foundation.utility.outliner.OutlineParticle;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.io.IOUtils;

public class SchematicAndQuillHandler {
    private BlockPos firstPos;
    private BlockPos secondPos;
    private BlockPos selectedPos;
    private Direction selectedFace;
    private int range = 10;
    private OutlineParticle<ChasingAABBOutline> particle;

    public boolean mouseScrolled(double delta) {
        if (!this.isActive()) {
            return false;
        }
        if (!AllKeys.ctrlDown()) {
            return false;
        }
        if (this.secondPos == null) {
            this.range = (int)MathHelper.func_151237_a((double)((double)this.range + delta), (double)1.0, (double)100.0);
        }
        if (this.selectedFace == null) {
            return true;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.firstPos, this.secondPos);
        Vec3i vec = this.selectedFace.func_176730_m();
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        if (bb.func_72318_a(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.func_177958_n() * delta);
        int y = (int)((double)vec.func_177956_o() * delta);
        int z = (int)((double)vec.func_177952_p() * delta);
        Direction.AxisDirection axisDirection = this.selectedFace.func_176743_c();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.func_72317_d((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.field_72336_d - (double)(x * axisDirection.func_179524_a()), bb.field_72340_a);
        double maxY = Math.max(bb.field_72337_e - (double)(y * axisDirection.func_179524_a()), bb.field_72338_b);
        double maxZ = Math.max(bb.field_72334_f - (double)(z * axisDirection.func_179524_a()), bb.field_72339_c);
        bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, maxX, maxY, maxZ);
        this.firstPos = new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        this.secondPos = new BlockPos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        Lang.sendStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "schematicAndQuill.dimensions", (int)bb.func_216364_b() + 1, (int)bb.func_216360_c() + 1, (int)bb.func_216362_d() + 1);
        return true;
    }

    public void onMouseInput(int button, boolean pressed) {
        if (!pressed || button != 1) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_70093_af()) {
            this.firstPos = null;
            this.secondPos = null;
            Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.abort", new Object[0]);
            return;
        }
        if (this.secondPos != null) {
            TextInputPromptScreen guiScreenIn = new TextInputPromptScreen(this::saveSchematic, s -> {});
            guiScreenIn.setTitle(Lang.translate("schematicAndQuill.prompt", new Object[0]));
            guiScreenIn.setButtonTextConfirm(Lang.translate("action.saveToFile", new Object[0]));
            guiScreenIn.setButtonTextAbort(Lang.translate("action.discard", new Object[0]));
            ScreenOpener.open(guiScreenIn);
            return;
        }
        if (this.selectedPos == null) {
            Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.noTarget", new Object[0]);
            return;
        }
        if (this.firstPos != null) {
            this.secondPos = this.selectedPos;
            Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.secondPos", new Object[0]);
            return;
        }
        this.firstPos = this.selectedPos;
        Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.firstPos", new Object[0]);
    }

    public void tick() {
        Vec3d projectedView;
        if (!this.isActive()) {
            if (this.particle != null) {
                this.particle.func_187112_i();
                this.particle = null;
            }
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            float pt = Minecraft.func_71410_x().func_184121_ak();
            Vec3d targetVec = player.func_174824_e(pt).func_178787_e(player.func_70040_Z().func_186678_a((double)this.range));
            this.setCursor(new BlockPos(targetVec));
        } else {
            BlockRayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (PlayerEntity)player, 75.0);
            if (trace != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos hit = trace.func_216350_a();
                boolean replaceable = player.field_70170_p.func_180495_p(hit).func_196953_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, trace)));
                if (trace.func_216354_b().func_176740_k().func_200128_b() && !replaceable) {
                    hit = hit.func_177972_a(trace.func_216354_b());
                }
                this.setCursor(hit);
            } else {
                this.setCursor(null);
            }
        }
        if (this.particle == null) {
            return;
        }
        ChasingAABBOutline outline = this.particle.getOutline();
        if (this.particle.func_187113_k()) {
            outline.tick();
        }
        if (this.secondPos == null) {
            this.selectedFace = null;
            outline.highlightFace(null);
            return;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.firstPos, this.secondPos).func_72321_a(1.0, 1.0, 1.0).func_186662_g((double)0.45f);
        boolean inside = bb.func_72318_a(projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c());
        RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((PlayerEntity)player, 70.0, pos -> inside ^ bb.func_72318_a(VecHelper.getCenterOf((Vec3i)pos)));
        this.selectedFace = result.missed() ? null : (inside ? result.getFacing().func_176734_d() : result.getFacing());
        outline.highlightFace(AllKeys.ACTIVATE_TOOL.isPressed() ? this.selectedFace : null);
    }

    private void setCursor(BlockPos pos) {
        ChasingAABBOutline outline;
        this.selectedPos = pos;
        AxisAlignedBB bb = this.getCurrentSelectionBox();
        if (this.particle != null && !this.particle.func_187113_k()) {
            this.particle = null;
        }
        if (bb == null) {
            if (this.particle != null) {
                this.particle.func_187112_i();
            }
            return;
        }
        if (this.particle == null) {
            outline = new ChasingAABBOutline(bb);
            outline.setTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED);
            this.particle = OutlineParticle.create(outline);
        }
        outline = this.particle.getOutline();
        outline.target(bb);
    }

    private AxisAlignedBB getCurrentSelectionBox() {
        if (this.secondPos == null) {
            if (this.firstPos == null) {
                return this.selectedPos == null ? null : new AxisAlignedBB(this.selectedPos);
            }
            return this.selectedPos == null ? new AxisAlignedBB(this.firstPos) : new AxisAlignedBB(this.firstPos, this.selectedPos).func_72321_a(1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(this.firstPos, this.secondPos).func_72321_a(1.0, 1.0, 1.0);
    }

    private boolean isActive() {
        return this.isPresent() && AllItems.BLUEPRINT_AND_QUILL.typeOf(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
    }

    private boolean isPresent() {
        return Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveSchematic(String string) {
        String filepath;
        block7: {
            Template t = new Template();
            MutableBoundingBox bb = new MutableBoundingBox((Vec3i)this.firstPos, (Vec3i)this.secondPos);
            t.func_186254_a((World)Minecraft.func_71410_x().field_71441_e, new BlockPos(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c), new BlockPos(bb.func_78883_b(), bb.func_78882_c(), bb.func_78880_d()), true, Blocks.field_150350_a);
            if (string.isEmpty()) {
                string = Lang.translate("schematicAndQuill.fallbackName", new Object[0]);
            }
            String folderPath = "schematics";
            FilesHelper.createFolderIfMissing(folderPath);
            String filename = FilesHelper.findFirstValidFilename(string, folderPath, "nbt");
            filepath = folderPath + "/" + filename;
            OutputStream outputStream = null;
            try {
                outputStream = Files.newOutputStream(Paths.get(filepath, new String[0]), StandardOpenOption.CREATE);
                CompoundNBT nbttagcompound = t.func_189552_a(new CompoundNBT());
                CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound, (OutputStream)outputStream);
                if (outputStream == null) break block7;
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            break block7;
            finally {
                if (outputStream != null) {
                    IOUtils.closeQuietly(outputStream);
                }
            }
        }
        this.firstPos = null;
        this.secondPos = null;
        Lang.sendStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "schematicAndQuill.saved", filepath);
    }
}

