/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllItems;
import com.simibubi.create.CreateClient;
import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.schematics.client.SchematicHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class SchematicEditScreen
extends AbstractSimiScreen {
    private TextFieldWidget xInput;
    private TextFieldWidget yInput;
    private TextFieldWidget zInput;
    private final List<String> rotationOptions = Lang.translatedOptions("schematic.rotation", "none", "cw90", "cw180", "cw270");
    private final List<String> mirrorOptions = Lang.translatedOptions("schematic.mirror", "none", "leftRight", "frontBack");
    private final String positionLabel = Lang.translate("schematic.position", new Object[0]);
    private final String rotationLabel = Lang.translate("schematic.rotation", new Object[0]);
    private final String mirrorLabel = Lang.translate("schematic.mirror", new Object[0]);
    private ScrollInput rotationArea;
    private ScrollInput mirrorArea;
    private SchematicHandler handler;

    protected void init() {
        this.setWindowSize(ScreenResources.SCHEMATIC.width + 50, ScreenResources.SCHEMATIC.height);
        int x = this.guiLeft;
        int y = this.guiTop;
        this.handler = CreateClient.schematicHandler;
        this.xInput = new TextFieldWidget(this.font, x + 75, y + 32, 32, 10, "");
        this.yInput = new TextFieldWidget(this.font, x + 115, y + 32, 32, 10, "");
        this.zInput = new TextFieldWidget(this.font, x + 155, y + 32, 32, 10, "");
        BlockPos anchor = this.handler.getTransformation().getAnchor();
        if (this.handler.isDeployed()) {
            this.xInput.func_146180_a("" + anchor.func_177958_n());
            this.yInput.func_146180_a("" + anchor.func_177956_o());
            this.zInput.func_146180_a("" + anchor.func_177952_p());
        } else {
            TextFieldWidget[] alt = this.minecraft.field_71439_g.func_180425_c();
            this.xInput.func_146180_a("" + alt.func_177958_n());
            this.yInput.func_146180_a("" + alt.func_177956_o());
            this.zInput.func_146180_a("" + alt.func_177952_p());
        }
        for (TextFieldWidget widget : new TextFieldWidget[]{this.xInput, this.yInput, this.zInput}) {
            widget.func_146203_f(6);
            widget.func_146185_a(false);
            widget.func_146193_g(0xFFFFFF);
            widget.changeFocus(false);
            widget.mouseClicked(0.0, 0.0, 0);
            widget.func_200675_a(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    Integer.parseInt(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
        PlacementSettings settings = this.handler.getTransformation().toSettings();
        Label labelR = new Label(x + 99, y + 52, "").withShadow();
        this.rotationArea = new SelectionScrollInput(x + 96, y + 49, 94, 14).forOptions(this.rotationOptions).titled("Rotation").setState(settings.func_186215_c().ordinal()).writingTo(labelR);
        Label labelM = new Label(x + 99, y + 72, "").withShadow();
        this.mirrorArea = new SelectionScrollInput(x + 96, y + 69, 94, 14).forOptions(this.mirrorOptions).titled("Mirror").setState(settings.func_186212_b().ordinal()).writingTo(labelM);
        Collections.addAll(this.widgets, this.xInput, this.yInput, this.zInput);
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{labelR, labelM, this.rotationArea, this.mirrorArea});
        super.init();
    }

    @Override
    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        String coords;
        if (SchematicEditScreen.isPaste((int)code) && (coords = this.minecraft.field_195559_v.func_197965_a()) != null && !coords.isEmpty()) {
            coords.replaceAll(" ", "");
            String[] split = coords.split(",");
            if (split.length == 3) {
                boolean valid = true;
                for (String s : split) {
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        valid = false;
                    }
                }
                if (valid) {
                    this.xInput.func_146180_a(split[0]);
                    this.yInput.func_146180_a(split[1]);
                    this.zInput.func_146180_a(split[2]);
                    return true;
                }
            }
        }
        return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        ScreenResources.SCHEMATIC.draw((AbstractGui)this, x, y);
        this.font.func_175063_a(this.handler.getCurrentSchematicName(), (float)(x + 103 - this.font.func_78256_a(this.handler.getCurrentSchematicName()) / 2), (float)(y + 10), 0xDDEEFF);
        this.font.func_211126_b(this.positionLabel, (float)(x + 10), (float)(y + 32), 5726074);
        this.font.func_211126_b(this.rotationLabel, (float)(x + 10), (float)(y + 52), 5726074);
        this.font.func_211126_b(this.mirrorLabel, (float)(x + 10), (float)(y + 72), 5726074);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(this.guiLeft + 220), (double)(this.guiTop + 20), (double)0.0);
        GlStateManager.scaled((double)3.0, (double)3.0, (double)3.0);
        this.itemRenderer.func_175042_a(new ItemStack((IItemProvider)AllItems.BLUEPRINT.get()), 0, 0);
        GlStateManager.popMatrix();
    }

    public void removed() {
        boolean validCoords = true;
        BlockPos newLocation = null;
        try {
            newLocation = new BlockPos(Integer.parseInt(this.xInput.func_146179_b()), Integer.parseInt(this.yInput.func_146179_b()), Integer.parseInt(this.zInput.func_146179_b()));
        }
        catch (NumberFormatException e) {
            validCoords = false;
        }
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.values()[this.rotationArea.getState()]);
        settings.func_186214_a(Mirror.values()[this.mirrorArea.getState()]);
        if (validCoords && newLocation != null) {
            ItemStack item = this.handler.getActiveSchematicItem();
            if (item != null) {
                item.func_77978_p().func_74757_a("Deployed", true);
                item.func_77978_p().func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)newLocation));
            }
            this.handler.getTransformation().init(newLocation, settings, this.handler.getBounds());
            this.handler.markDirty();
            this.handler.deploy();
        }
    }
}

